<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Backend\Bank;

class MoroccanBanksSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $banks = [
            'ATTIJARIWAFA BANK',
            'BANQUE CENTRALE POPULAIRE (BCP)',
            'BANK OF AFRICA (BOA)',
            'BANQUE MAROCAINE POUR LE COMMERCE ET L\'INDUSTRIE (BMCI)',
            'CREDIT AGRICOLE DU MAROC (CAM)',
            'CREDIT DU MAROC (CDM)',
            'SOCIETE GENERALE MAROCAINE DE BANQUES (SGMB)',
            'AL BARID BANK',
            'ARAB BANK MAROC',
            'CFG BANK',
            'CITIBANK MAGHREB',
            'UMNIA BANK',
            'BANK AL-YOUSR',
            'BTI BANK',
            'BANQUE ASSAFA',
        ];

        foreach ($banks as $name) {
            Bank::firstOrCreate(['name' => $name]);
        }
    }
}
