<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Enums\Status;

class MoroccoHubSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $cities = [
            'Casablanca',
            'Rabat',
            'Fès',
            'Tanger',
            'Marrakech',
            'Agadir',
            'Meknès',
            'Oujda',
            'Kenitra',
            'Tetouan',
            'Safi',
            'Mohammedia',
            'Khouribga',
            'El Jadida',
            'Béni Mellal',
            'Nador',
            'Taza',
            'Settat',
            'Berrechid',
            'Khemisset',
            'Inezgane',
            'Ksar El Kebir',
            'Larache',
            'Guelmim',
            'Khenifra',
            'Berkane',
            'Taourirt',
            'Bouskoura',
            'Fquih Ben Salah',
            'Dakhla',
            'Errachidia',
            'Guercif',
            'Ouarzazate',
            'Tiznit',
            'Taroudant',
            'Essaouira',
            'Chefchaouen',
            'Al Hoceïma',
            'Azrou',
            'Sidi Slimane',
            'Sidi Kacem',
            'Tan-Tan',
            'Oulad Teima',
            'Youssoufia',
            'Sefrou',
            'Ben Guerir',
            'Sidi Qacem',
            'Fnideq',
            'Sidi Ifni',
            'Moulay Driss Zerhoun',
            'Ahfir',
            'Demnate',
            'Bouznika',
            'Souk El Arbaa',
            'Tiflet',
            'Kelaat M\'Gouna',
            'Midelt',
            'Azemmour',
            'Skhirat',
            'Souk Sebt Oulad Nemma',
            'Kasba Tadla',
            'Sidi Bennour',
            'Martil',
            'Mechra Bel Ksiri',
            'Ouezzane',
            'Zagora',
            'Sidi Taibi',
            'Ain El Aouda',
            'Beni Yakhlef',
            'Ait Melloul',
            'Biougra',
            'Drargua',
            'El Aaiún',
            'Boujdour',
            'Smara',
            'Lagouira',
            'Tarfaya',
            'Laayoune',
            'Goulmima',
            'Er-Rich',
            'Jorf',
            'Tinjdad',
            'Tinghir',
            'Alnif',
            'Rissani',
            'Erfoud',
            'Boumalne Dades',
            'Skoura',
            'Taznakht',
            'M\'Hamid El Ghizlane',
            'Agdz',
            'Taliouine',
            'Tata',
            'Akka',
            'Foum Zguid',
            'Assa',
            'Zag',
            'Fam El Hisn',
            'Lakhsas',
            'Bouizakarne',
            'Taghjijt',
            'El Ouatia',
            'Akhfenir',
            'El Marsa',
            'Bir Gandouz',
            'Aousserd',
            'Tichla',
            'Bir Anzarane',
            'Imlili',
            'Mahbes',
            'Es-Semara',
            'Jdiriya',
            'Haouza',
            'Amgala',
            'Tfariti',
            'Bir Lahlou',
            'Meharrize',
            'Tifariti',
            'Bir Lehlou',
            'Touizgui',
            'Al Mahbes',
            'Farcia',
            'Guelta Zemmur',
            'Bir Mogrein',
            'Zouer',
            'Ain Ben Tili',
            'Tindouf',
            'Beni Ounif',
            'Figuig',
            'Bouarfa',
            'Tendrara',
            'Ain Bni Mathar',
            'Jerada',
            'Touissit',
            'Sidi Boubker',
            'Tiouli',
            'Ras El Ma',
            'Beni Ensar',
            'Zeghanghane',
            'Al Aaroui',
            'Selouane',
            'Zaio',
            'Saidia',
            'Aklim',
            'Madagh',
            'Tafoughalt',
            'Beni Drar',
            'Naima',
            'El Aioun Sidi Mellouk',
            'Tahla',
            'Oued Amlil',
            'Aknoul',
            'Bni Frassen',
            'Zerarda',
            'Ribate El Kheir',
            'Bhalil',
            'El Menzel',
            'Immouzer Kandar',
            'Ifrane',
            'Ain Leuh',
            'Timahdite',
            'El Hajeb',
            'Agourai',
            'Ain Taoujdate',
            'Sabaa Aiyoun',
            'Boufakrane',
            'Toulal',
            'Ouislane',
            'Meshwar Fes Jdid',
            'Ouled Tayeb',
            'Sidi Harazem',
            'Ain Cheggag',
            'Moulay Yacoub',
            'Jorf El Melha',
            'Had Kourt',
            'Sidi Yahya El Gharb',
            'Asilah',
            'Ksar es Seghir',
            'M\'diq',
            'Oued Laou',
            'Bab Berred',
            'Bab Taza',
            'Dardara',
            'Moqrisset',
            'Zoumi',
            'Sidi Redouane',
            'Ain Dorij',
            'Bni Quolla',
            'Lamjaara',
            'Terwal',
            'Zghira',
            'Taounate',
            'Tissa',
            'Ghafsai',
            'Karia Ba Mohamed',
            'Ain Aicha',
            'Bni Oulid',
            'Galaz',
            'Oulad Daoud',
            'Bouhouda',
            'Matamata',
            'Ain Jemaa',
            'Tiddas',
            'Oulmes',
            'Sidi Allal El Bahraoui',
            'Temara',
            'Salé',
            'Bouknadel',
            'Mehdya',
            'Moulay Bousselham',
            'Lalla Mimouna',
            'Arbaoua'
        ];

        foreach ($cities as $city) {
            \App\Models\Backend\Hub::firstOrCreate(
                ['name' => $city],
                [
                    'phone' => '0000000000',
                    'address' => $city . ', Morocco',
                    'status' => Status::ACTIVE,
                ]
            );
        }
    }
}
