<form action="{{route('merchant.paymentinfo.bank.store')}}" method="POST" enctype="multipart/form-data" id="basicform">
    @csrf
    <input id="merchant_id" type="hidden" name="merchant_id" value="{{ $merchant_id }}" />
    <input type="hidden" id="payment_method_name" value="{{ $payment_method }}" name="payment_method_name" />
    @if(isset($editid) !== null)
        <input type="hidden" name="editid" value="{{ $editid }}" />
    @endif
    <div class="form-group  ">
        <label for="bank_name">{{ __('merchant.select_bank') }}</label> <span class="text-danger">*</span>
        <select id="bank_name" name="bank_name" class="form-control @error('bank_name') is-invalid @enderror" ">
            @foreach ($banks as $bank)
                <option value=" {{$bank->id}}">{{ $bank->name }}</option>
            @endforeach
        </select>
        @error('bank_name')
            <small class="text-danger mt-2">{{ $message }}</small>
        @enderror
    </div>
    <div class="form-group">
        <label for="holder_name">{{ __('merchant.holder_name') }}</label> <span class="text-danger">*</span>
        <input id="holder_name" type="text" name="holder_name" data-parsley-trigger="change"
            placeholder="{{ __('placeholder.Account_Holder_Name') }}" autocomplete="off" class="form-control"
            value="{{old('holder_name')}}" require>
        @error('holder_name')
            <small class="text-danger mt-2">{{ $message }}</small>
        @enderror
    </div>
    <div class="form-group">
        <label for="account_no">{{ __('merchant.account_no') }}</label> <span class="text-danger">*</span>
        <input id="account_no" type="text" name="account_no" data-parsley-trigger="change"
            placeholder="{{ __('placeholder.Enter_account_no') }}" autocomplete="off" class="form-control"
            value="{{old('account_no')}}" required minlength="24" maxlength="24" pattern="[0-9]{24}"
            title="Le numéro de compte doit contenir exactement 24 chiffres">
        @error('account_no')
            <small class="text-danger mt-2">{{ $message }}</small>
        @enderror
    </div>

    <div class="form-group">
        <label for="status">{{__('levels.status')}}</label> <span class="text-danger">*</span>
        <select name="status" class="form-control @error('status') is-invalid @enderror">
            @foreach(trans('status') as $key => $status)
                <option value="{{ $key }}" {{ (old('status', \App\Enums\Status::ACTIVE) == $key) ? 'selected' : '' }}>
                    {{ $status }}</option>
            @endforeach
        </select>
        @error('status')
            <small class="text-danger mt-2">{{ $message }}</small>
        @enderror
    </div>
    <div class="row">
        <div class="col-12">
            <div class="form-group">
                <button type="submit" class="btn btn-space btn-primary">{{ __('levels.submit') }}</button>
                <a href="{{ route('merchant.paymentaccount.index', $merchant_id) }}"
                    class="btn btn-space btn-secondary">{{ __('levels.cancel') }}</a>
            </div>
        </div>
    </div>
</form>