<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <style>
        @media print {
            @page {
                size: A4 landscape;
                margin: 0;
            }

            body {
                margin: 0;
                padding: 0;
                -webkit-print-color-adjust: exact;
            }
        }

        body {
            font-family: 'Arial', sans-serif;
            background: #fff;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 290mm;
            /* A4 Landscape width approx */
            height: 200mm;
            /* A4 Landscape height approx */
            border: 2px solid #000;
            margin: 5mm auto;
            position: relative;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        /* HEADER */
        .header {
            height: 15%;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
            border-bottom: 3px solid #000366;
        }

        .header-logo {
            max-height: 60px;
        }

        .header-decorative {
            font-size: 10px;
            color: #555;
            text-align: right;
        }

        /* RED BAR */
        .red-bar {
            background-color: #000366;
            color: white;
            height: 8%;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            font-weight: bold;
            font-size: 18px;
            border-bottom: 2px solid #000;
        }

        /* MAIN CONTENT */
        .content {
            display: flex;
            flex-grow: 1;
            border-bottom: 2px solid #000;
        }

        .col-left {
            width: 65%;
            border-right: 2px solid #000;
            display: flex;
            flex-direction: column;
        }

        .col-right {
            width: 35%;
            display: flex;
            flex-direction: column;
        }

        /* SECTIONS */
        .section-box {
            padding: 10px;
            border-bottom: 1px solid #000;
        }

        .section-box:last-child {
            border-bottom: none;
        }

        .info-title {
            font-weight: bold;
            text-transform: uppercase;
            font-size: 14px;
            margin-bottom: 5px;
            text-decoration: underline;
        }

        .info-text {
            font-size: 18px;
            margin-bottom: 3px;
        }

        .info-sub {
            font-size: 14px;
        }

        /* RIGHT COLUMN SPECIFICS */
        .zone-box {
            background: #000366;
            color: white;
            font-size: 24px;
            font-weight: bold;
            text-align: center;
            padding: 15px;
            border-bottom: 2px solid #000;
        }

        .qr-box {
            flex-grow: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #000;
        }

        .qr-box img {
            width: 120px;
            height: 120px;
        }

        .allow-opening-box {
            text-align: center;
            font-weight: bold;
            padding: 10px;
            font-size: 18px;
            border: 2px solid #000;
            margin: 10px;
        }

        .delivery-type-box {
            background: #000366;
            color: white;
            text-align: center;
            font-weight: bold;
            font-size: 20px;
            padding: 10px;
            border-top: 2px solid #000;
            border-bottom: 2px solid #000;
        }

        .price-box {
            text-align: center;
            padding: 10px;
        }

        .price-label {
            font-size: 14px;
            font-weight: bold;
        }

        .price-value {
            font-size: 32px;
            font-weight: bold;
        }

        /* FOOTER */
        .footer {
            height: 20%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            position: relative;
        }

        .footer-warning {
            background: #000366;
            color: white;
            width: 100%;
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            padding: 5px 0;
            margin-bottom: 10px;
            direction: rtl;
        }

        .footer-barcode {
            margin-bottom: 5px;
        }

        .footer-msg {
            font-size: 10px;
            font-weight: bold;
            color: #000366;
        }
    </style>
</head>

<body>
    <div class="container">
        <!-- HEADER -->
        <div class="header">
            <img src="{{ settings()->logo_image }}" alt="Logo" class="header-logo">
            <div class="header-decorative">
                {{ settings()->name }}<br>
                {{ settings()->name }}
            </div>
        </div>

        <!-- RED BAR -->
        <div class="red-bar">
            <span>{{ $parcel->tracking_id }}</span>
            <span>{{ optional($parcel->hub)->name }} | {{ $parcel->customer_address }}</span>
        </div>

        <!-- CONTENT -->
        <div class="content">
            <!-- LEFT COLUMN -->
            <div class="col-left">
                <div class="section-box" style="height: 30%;">
                    <div class="info-title">Expéditeur: {{ $parcel->merchant->business_name }}</div>
                    <div class="info-sub">
                        Téléphone: {{ $parcel->merchant->user->mobile }}<br>
                        Date: {{ $parcel->created_at->format('Y-m-d H:i') }}
                    </div>
                </div>

                <div class="section-box" style="flex-grow: 1;">
                    <div class="info-title">Destinataire: {{ $parcel->customer_name }}</div>
                    <div class="info-text">Téléphone: {{ $parcel->customer_phone }}</div>
                    <div class="info-text">Ville: {{ optional($parcel->hub)->name }}</div>
                    <div class="info-text">Adresse: {{ $parcel->customer_address }}</div>
                    @if($parcel->note)
                        <div class="info-sub" style="margin-top: 5px;"><strong>Commentaire:</strong> {{ $parcel->note }}
                        </div>
                    @endif
                    <div class="info-sub" style="margin-top: 10px;">
                        <strong>Nature Du Produit:</strong> {{ optional($parcel->deliveryCategory)->title }}
                    </div>
                </div>
            </div>

            <!-- RIGHT COLUMN -->
            <div class="col-right">
                <div class="zone-box">
                    {{ optional($parcel->hub)->name }}
                </div>

                <div class="qr-box">
                    <img src="{{ $parcel->qrcodeprint }}" alt="QR Code">
                </div>

                @if($parcel->open_parcel)
                    <div class="allow-opening-box">
                        {{ __('parcel.allow_opening') }}
                    </div>
                @endif

                <div class="delivery-type-box">
                    À domicile
                </div>

                <div class="price-box">
                    <div class="price-label">CRBT: {{ $parcel->cash_collection > 0 ? 'C/Espèce' : 'Payé' }}</div>
                    <div class="price-value">{{ number_format($parcel->cash_collection, 2) }} DH</div>
                </div>

                <div class="footer-msg"
                    style="text-align: center; margin-top: 10px; font-size: 14px; font-weight: bold; background-color: #000366; color: white; padding: 5px;">
                    {{ $parcel->merchant->business_name }} Vous remercie pour votre confiance.
                </div>
            </div>
        </div>

        <!-- FOOTER -->
        <div class="footer">
            <div class="footer-warning">
                تذكير: {{ settings()->name }} شركة مكلفة بالتوصيل فقط
            </div>

            <div class="footer-barcode">
                {!! $parcel->barcodeprint !!}
            </div>
            <div>{{ $parcel->tracking_id }}</div>

        </div>
    </div>
    <script>
        window.print();
    </script>
</body>

</html>