<?php $__env->startSection('title'); ?>
    <?php echo e(__('fraud.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link"><?php echo e(__('fraud.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- data table  -->
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-6">
                        <p class="h3"><?php echo e(__('fraud.title')); ?></p>
                    </div>
                    <?php if(hasPermission('fraud_create') == true): ?>
                        <div class="col-6">
                            <a href="<?php echo e(route('fraud.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('levels.phone')); ?></th>
                                    <th><?php echo e(__('levels.name')); ?></th>
                                    <th><?php echo e(__('levels.track_id')); ?></th>
                                    <?php if(hasPermission('fraud_update') == true || hasPermission('fraud_delete') == true ): ?>
                                        <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $frauds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fraud): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td><?php echo e($fraud->phone); ?></td>
                                    <td><?php echo e($fraud->name); ?></td>
                                    <td><?php echo e($fraud->tracking_id); ?></td>
                                    <?php if(hasPermission('fraud_update') == true || hasPermission('fraud_delete') == true ): ?>
                                    <td>
                                        <div class="row">
                                            <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                            <div class="dropdown-menu">
                                                <?php if(hasPermission('fraud_update') == true  ): ?>
                                                    <a href="<?php echo e(route('fraud.edit',$fraud->id)); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                <?php endif; ?>
                                                <?php if(hasPermission('fraud_delete') == true ): ?>
                                                    <form id="delete" value="Test" action="<?php echo e(route('fraud.delete',$fraud->id)); ?>" method="POST" data-title="<?php echo e(__('delete.fraud')); ?>">
                                                        <?php echo method_field('DELETE'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="" value="<?php echo e(__('fraud.title')); ?>" id="deleteTitle">
                                                        <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                    </form>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-12">
                    <div class="table-responsive">
                        <span><?php echo e($frauds->links()); ?></span>
                        <p class="p-2 small">
                            <?php echo __('Showing'); ?>

                            <span class="font-medium"><?php echo e($frauds->firstItem()); ?></span>
                            <?php echo __('to'); ?>

                            <span class="font-medium"><?php echo e($frauds->lastItem()); ?></span>
                            <?php echo __('of'); ?>

                            <span class="font-medium"><?php echo e($frauds->total()); ?></span>
                            <?php echo __('results'); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- end data table  -->
    </div>
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/fraud/index.blade.php ENDPATH**/ ?>