<?php $__env->startSection('title'); ?>
    <?php echo e(__('incharge.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('incharge.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('hubs.index')); ?>" class="breadcrumb-link"><?php echo e(__('hubs.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('hub-incharge.index',$hub->id)); ?>" class="breadcrumb-link"><?php echo e(__('incharge.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('incharge.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- data table  -->
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-6">
                        <p class="h3"> <?php echo e($hub->name); ?> <?php echo e(__('incharge.title')); ?></p>
                    </div>
                    <?php if( hasPermission('hub_incharge_create')    == true ): ?>
                    <div class="col-6">
                        <a href="<?php echo e(route('hub-incharge.create',$hub->id)); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('levels.user')); ?></th>
                                    <th><?php echo e(__('levels.phone')); ?></th>
                                    <th><?php echo e(__('levels.assigned_date')); ?></th>
                                    <th><?php echo e(__('levels.status')); ?></th>
                                    <?php if(
                                        hasPermission('hub_incharge_update')    == true ||
                                        hasPermission('hub_incharge_delete')    == true
                                        ): ?>
                                    <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if(!blank($hubInCharges)): ?>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $hubInCharges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $incharge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td>
                                        <div class="row">
                                            <div class="pr-3">
                                                <img src="<?php echo e($incharge->user->image); ?>" alt="user" class="rounded" width="40" height="40">
                                            </div>
                                            <div>
                                                <strong><?php echo e($incharge->user->name); ?></strong>
                                                <p><?php echo e($incharge->user->email); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($incharge->user->mobile); ?></td>
                                    <td><?php echo e(date('d M Y', strtotime($incharge->updated_at))); ?></td>
                                    <td><?php echo $incharge->my_status; ?></td>
                                    <?php if(
                                        hasPermission('hub_incharge_update')    == true ||
                                        hasPermission('hub_incharge_delete')    == true
                                        ): ?>
                                    <td>
                                        <div class="row">
                                            <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only"><?php echo e(__('Toggle Dropdown')); ?></span></button>
                                            <div class="dropdown-menu">
                                            <?php if( hasPermission('hub_incharge_update')    == true): ?>
                                                <a href="<?php echo e(route('hub-incharge.edit',[$hub->id,$incharge])); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                            <?php endif; ?>
                                            <?php if( hasPermission('hub_incharge_delete')    == true ): ?>
                                                <form id="delete" value="Test" action="<?php echo e(route('hub-incharge.destroy',[$hub->id,$incharge])); ?>" method="POST" data-title="<?php echo e(__('delete.hub_incharge')); ?>">
                                                    <?php echo method_field('DELETE'); ?>
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="" value="Hub incharge" id="deleteTitle">
                                                    <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                </form>
                                            <?php endif; ?>
                                            <?php if( hasPermission('hub_incharge_assigned')    == true ): ?>
                                                <a href="<?php echo e(route('hub-incharge.assigned',[$hub->id,$incharge])); ?>" class="dropdown-item"><i class="fas fa-plus-circle" aria-hidden="true"></i> <?php echo e(__('incharge.assigned')); ?></a>
                                            <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>

                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- end data table  -->
    </div>
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/hubincharge/index.blade.php ENDPATH**/ ?>