<?php $__env->startSection('title'); ?>
    <?php echo e(__('parcel.title')); ?>    <?php echo e(__('View Proof of Delivery')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('parcel.index')); ?>" class="breadcrumb-link"><?php echo e(__('parcel.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('View Proof of Delivery')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <section class="mt-5 pt-5">
        <div class="row">
            <div class="col-xl-8 ">
                <section class="cd-timeline js-cd-timeline">
                    <div class="cd-timeline__container">
                        <?php $__currentLoopData = $parcelevents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php switch($log->parcel_status):
                                case (\App\Enums\ParcelStatus::DELIVERED): ?>
                                    <div class="cd-timeline__block js-cd-block">
                                        <!-- cd-timeline__img -->
                                        <div class="active cd-timeline__content js-cd-content">
                                            <strong><?php echo e(__('parcelLogs.'.@$log->parcel_status)); ?></strong><br>
                                            <span><?php echo e(__('levels.note')); ?>: <?php echo e(@$log->note); ?></span><br/>
                                            <div >
                                                <strong><?php echo @dateFormat($log->created_at); ?></strong><br>
                                                <small><?php echo @date('h:i a', strtotime($log->created_at)); ?></small>
                                            </div>
                                            <div class="row mt-2">
                                                <div class="col-md-6">
                                                    <strong class="mb-2">Delivered Photo</strong>
                                                    <?php if($log->delivered_image): ?> 
                                                        <img src="<?php echo e(static_asset(@$log->delivered_image)); ?>" style="width: 100%;height: 300px;" alt="delivered_image" class="img-responsive mt-2" >
                                                    <?php endif; ?>
                                                </div>
                                                <div class="col-md-6">
                                                    <strong class="mb-2">Signature</strong>
                                                    <?php if($log->signature_image): ?> 
                                                        <img src="<?php echo e(static_asset(@$log->signature_image)); ?>" style="width: 100%;height: 150px;"  alt="signature_image" class="img-responsive mt-2" >
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- cd-timeline__content -->
                                    </div>
                                <?php break; ?>
                                <?php case (\App\Enums\ParcelStatus::PARTIAL_DELIVERED): ?>
                                    <div class="active cd-timeline__block js-cd-block">
                                        <!-- cd-timeline__img -->
                                        <div class="cd-timeline__content js-cd-content">
                                            <strong><?php echo e(__('parcelLogs.'.@$log->parcel_status)); ?></strong><br>
                                            <span><?php echo e(__('levels.note')); ?>: <?php echo e(@$log->note); ?></span><br/>
                                            <div >
                                                <strong><?php echo @dateFormat($log->created_at); ?></strong><br>
                                                <small><?php echo @date('h:i a', strtotime($log->created_at)); ?></small>
                                            </div>
                                        </div>
                                        <!-- cd-timeline__content -->
                                    </div>
                                <?php break; ?>
                                <?php default: ?>
                                    <div class="cd-timeline__block js-cd-block"></div>
                            <?php endswitch; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </section>
            </div>
        </div>
    </section>
    <!-- end timeline  -->
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>
<!-- css  -->
<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(static_asset('backend')); ?>/css/logs.css">
<?php $__env->stopPush(); ?>



<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/parcel/parcel-delivered-info.blade.php ENDPATH**/ ?>