<?php $__env->startSection('title'); ?>
    <?php echo e(__('menus.banks')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
    <!-- wrapper  -->
    <div class="container-fluid  dashboard-content">
        <!-- page header -->
        <div class="row">
            <div class="col-12">
                <div class="page-header">
                    <div class="page-breadcrumb">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>"
                                        class="breadcrumb-link"><?php echo e(__('menus.dashboard')); ?></a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('bank.index')); ?>"
                                        class="breadcrumb-link"><?php echo e(__('menus.banks')); ?></a></li>
                                <li class="breadcrumb-item"><a href="#"
                                        class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- end page header -->
        <div class="row">
            <!-- data table  -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('bank.filter')); ?>" method="GET">
                            <div class="row d-flex align-items-center">
                                <label for="name"><?php echo e(__('bank.name')); ?></label>
                                <div class="form-group col-12 col-sm-6 col-md-4 col-lg-4 col-xl-2">
                                    <input type="text" autocomplete="off" id="name" name="name"
                                        placeholder="<?php echo e(__('bank.name')); ?>" class="form-control"
                                        value="<?php echo e(old('name', request('name'))); ?>">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-12 col-sm-6 col-md-4 col-lg-4 col-xl-2 pt-1 pl-0">
                                    <div class="col-12 d-flex justify-content text-right">
                                        <button type="submit" class="btn btn-sm btn-space btn-primary"><i
                                                class="fa fa-filter"></i> <?php echo e(__('levels.filter')); ?></button>
                                        <a href="<?php echo e(route('bank.index')); ?>" class="btn btn-sm btn-space btn-secondary"><i
                                                class="fa fa-eraser"></i> <?php echo e(__('levels.clear')); ?></a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <div class="row">
                                <div class="col-12 d-flex justify-content-between">
                                    <h4 class="mb-0"><?php echo e(__('menus.banks')); ?></h4>
                                    <a href="<?php echo e(route('bank.create')); ?>" class="btn btn-primary btn-sm"
                                        data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i
                                            class="fa fa-plus"></i></a>
                                </div>
                            </div>
                            <table id="table" class="table    parcelTable" style="width:100%">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('###')); ?></th>
                                        <th><?php echo e(__('bank.name')); ?></th>
                                        <th><?php echo e(__('levels.actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $i = 1;
                                    ?>
                                    <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e($bank->name); ?></td>
                                            <td>
                                                <div class="row">
                                                    <button tabindex="-1" data-toggle="dropdown" type="button"
                                                        class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span
                                                            class="sr-only">Toggle Dropdown</span></button>
                                                    <div class="dropdown-menu">
                                                        <a href="<?php echo e(route('bank.edit', $bank->id)); ?>"
                                                            class="dropdown-item"><i class="fas fa-edit"
                                                                aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                        <form id="delete" value="Test"
                                                            action="<?php echo e(route('bank.destroy', $bank->id)); ?>" method="POST"
                                                            data-title="<?php echo e(__('delete.bank')); ?>">
                                                            <?php echo method_field('DELETE'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="" value="Bank"
                                                                id="deleteTitle">
                                                            <button type="submit" class="dropdown-item"><i
                                                                    class="fa fa-trash" aria-hidden="true"></i>
                                                                <?php echo e(__('levels.delete')); ?></button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>
                    </div>
                    <div class="col-12 mt-3">
                        <div class="table-responsive">
                            <span><?php echo e($banks->links()); ?></span>
                            <p class="p-2 small">
                                <?php echo __('Showing'); ?>

                                <span class="font-medium"><?php echo e($banks->firstItem()); ?></span>
                                <?php echo __('to'); ?>

                                <span class="font-medium"><?php echo e($banks->lastItem()); ?></span>
                                <?php echo __('of'); ?>

                                <span class="font-medium"><?php echo e($banks->total()); ?></span>
                                <?php echo __('results'); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end data table  -->
        </div>
    </div>
    <!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/bank/index.blade.php ENDPATH**/ ?>