<?php $__env->startSection('title'); ?>
   <?php echo e(__('to_do.to_do_list')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid  dashboard-content">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('to_do.to_do_list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-6">
                        <p class="h3"><?php echo e(__('to_do.to_do_list')); ?></p>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('to_do.sl')); ?></th>
                                    <th><?php echo e(__('to_do.date')); ?></th>
                                    <th><?php echo e(__('to_do.title')); ?></th>
                                    <th><?php echo e(__('to_do.description')); ?></th>
                                    <th><?php echo e(__('to_do.assign')); ?></th>
                                    <th><?php echo e(__('to_do.note')); ?></th>
                                    <th><?php echo e(__('to_do.status')); ?></th>
                                    <th><?php echo e(__('to_do.status_update')); ?></th>
                                    <th><?php echo e(__('to_do.action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $todos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td> <?php echo e(dateFormat($todo->date)); ?></td>
                                    <td> <?php echo e($todo->title); ?></td>
                                    <td> <?php echo e(\Str::limit($todo->description,100,' ...')); ?></td>
                                    <td> <?php echo e($todo->user->name); ?></td>
                                    <td> <?php echo e($todo->note); ?></td>
                                    <td>
                                        <?php echo $todo->TodoStatus; ?> <br>
                                        <?php if($todo->partial_delivered && $todo->status != \App\Enums\TodoStatus::PENDING): ?>
                                            <span class="badge badge-pill badge-success mt-2"><?php echo e(trans("to_do." . \App\Enums\todoStatus::PENDING)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($todo->status == \App\Enums\TodoStatus::COMPLETED): ?>
                                            ...
                                            <?php else: ?>
                                        <div class="input-group mb-3">
                                            <div class="input-group-prepend be-addon">
                                                <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary btn-sm dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                                <div class="dropdown-menu">
                                                    <?php echo TodoStatus($todo); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="row">
                                            <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-sm ml-2">...</button>
                                            <div class="dropdown-menu">
                                                <?php if(hasPermission('todo_update')== true): ?>
                                                <a href="" class="dropdown-item" id="todoeditModal1" data-target="#todoeditModal<?php echo e($todo->id); ?>" data-toggle="modal"><i class="fa fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                <?php endif; ?>
                                                <?php if(hasPermission('todo_delete')== true): ?>
                                                <form id="delete" value="Test" action="<?php echo e(route('todo.delete',$todo->id)); ?>" method="POST" data-title="<?php echo e(__('delete.to_do')); ?>">
                                                    <?php echo method_field('DELETE'); ?>
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="" value="<?php echo e(__('todo.delete')); ?>" id="deleteTitle">
                                                    <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('to_do.delete')); ?></button>
                                                </form>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php echo $__env->make('backend.todo.to_do_edit', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="px-3 d-flex flex-row-reverse align-items-center">
                    <span><?php echo e($todos->links()); ?></span>
                    <p class="p-2 small">
                        <?php echo __('Showing'); ?>

                        <span class="font-medium"><?php echo e($todos->firstItem()); ?></span>
                        <?php echo __('to'); ?>

                        <span class="font-medium"><?php echo e($todos->lastItem()); ?></span>
                        <?php echo __('of'); ?>

                        <span class="font-medium"><?php echo e($todos->total()); ?></span>
                        <?php echo __('results'); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('backend.todo.to_do_proccesing', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('backend.todo.to_do_completed', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        $(document).ready(function(){
            $('#todo_btn').click(function(){
                var id = $(this).data('id');
                  $(".modal_todo_id").attr("value",id);
            });
        });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/todo/index.blade.php ENDPATH**/ ?>