<?php $__env->startSection('title'); ?>
    <?php echo e(__('hub.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
    <!-- wrapper  -->
    <div class="container-fluid  dashboard-content">
        <!-- pageheader -->
        <div class="row">
            <div class="col-12">
                <div class="page-header">
                    <div class="page-breadcrumb">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"
                                        class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                                <li class="breadcrumb-item"><a href="" class="breadcrumb-link"><?php echo e(__('hub.title')); ?></a></li>
                                <li class="breadcrumb-item"><a href=""
                                        class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- end pageheader -->
        <div class="row">
            <!-- data table  -->
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('hubs.filter')); ?>" method="GET">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-12 col-lg-4 col-md-4">
                                    <label for="name"><?php echo e(__('levels.name')); ?></label>
                                    <input type="text" id="name" name="name" placeholder="<?php echo e(__('placeholder.Hub_name')); ?>"
                                        class="form-control" value="<?php echo e(old('name', $request->name)); ?>">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-12 col-lg-4 col-md-4">
                                    <label for="phone"><?php echo e(__('levels.phone')); ?></label> <span class="text-danger"></span>
                                    <input type="text" id="phone" name="phone" placeholder="<?php echo e(__('placeholder.phone')); ?>"
                                        class="form-control" value="<?php echo e(old('phone', $request->phone)); ?>">
                                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group col-12 col-lg-4 col-md-4  pt-4">
                                    <div class="d-flex">
                                        <a href="<?php echo e(route('hubs.index')); ?>" class="btn btn-space btn-secondary"><i
                                                class="fa fa-eraser"></i> <?php echo e(__('levels.clear')); ?></a>
                                        <button type="submit" class="btn btn-space btn-primary"><i class="fa fa-filter"></i>
                                            <?php echo e(__('levels.filter')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card">
                    <div class="row pl-4 pr-4 pt-4">
                        <div class="col-6">
                            <p class="h3"><?php echo e(__('hub.title')); ?></p>
                        </div>
                        <div class="col-6">
                            <?php if(hasPermission('hub_create') == true): ?>
                                <a href="<?php echo e(route('hubs.create')); ?>" class="btn btn-primary btn-sm float-right"
                                    data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i
                                        class="fa fa-plus"></i></a>
                            <?php endif; ?>
                            <a href="<?php echo e(route('parcel.parcel.hubs')); ?>" target="_blank"
                                class="btn btn-sm btn-secondary mr-1 float-right" data-toggle="tooltip" data-placement="top"
                                title="Parcel Map"><i class="fa fa-map-location"></i> <?php echo e(__('hub.map')); ?></a>
                        </div>


                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table   ">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('levels.id')); ?></th>
                                        <th><?php echo e(__('levels.name')); ?></th>
                                        <th><?php echo e(__('levels.phone')); ?></th>
                                        <th><?php echo e(__('levels.address')); ?></th>
                                        <th><?php echo e(__('levels.status')); ?></th>
                                        <?php if(
                                                hasPermission('hub_update') == true ||
                                                hasPermission('hub_delete') == true ||
                                                hasPermission('hub_incharge_read') == true
                                            ): ?>
                                            <th><?php echo e(__('levels.actions')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i = 1; ?>
                                    <?php $__currentLoopData = $hubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($hub->id); ?></td>
                                            <td><?php echo e($hub->name); ?></td>
                                            <td><?php echo e($hub->phone); ?></td>
                                            <td><?php echo e($hub->address); ?></td>
                                            <td>
                                                <?php if($hub->status == \App\Enums\Status::ACTIVE): ?>
                                                    <span class="badge badge-pill badge-success"><?php echo e($hub->my_status); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-pill badge-danger"><?php echo e($hub->my_status); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <?php if(
                                                    hasPermission('hub_update') == true ||
                                                    hasPermission('hub_delete') == true ||
                                                    hasPermission('hub_incharge_read') == true
                                                ): ?>
                                                <td>
                                                    <div class="row">

                                                        <button tabindex="-1" data-toggle="dropdown" type="button"
                                                            class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span
                                                                class="sr-only">Toggle Dropdown</span></button>

                                                        <div class="dropdown-menu">
                                                            <?php if(hasPermission('hub_view') == true): ?>
                                                                <a href="<?php echo e(route('hub.view', $hub->id)); ?>" class="dropdown-item"><i
                                                                        class="fas fa-eye" aria-hidden="true"></i>
                                                                    <?php echo e(__('levels.view')); ?></a>
                                                            <?php endif; ?>

                                                            <?php if(hasPermission('hub_update') == true): ?>
                                                                <a href="<?php echo e(route('hubs.edit', $hub->id)); ?>" class="dropdown-item"><i
                                                                        class="fas fa-edit" aria-hidden="true"></i>
                                                                    <?php echo e(__('levels.edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(hasPermission('hub_incharge_read') == true): ?>
                                                                <a href="<?php echo e(route('hub-incharge.index', $hub->id)); ?>"
                                                                    class="dropdown-item"><i class="fas fa-plus-circle"
                                                                        aria-hidden="true"></i> <?php echo e(__('hubs.hub_incharge')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(hasPermission('hub_delete') == true): ?>
                                                                <form action="<?php echo e(route('hub.delete', $hub->id)); ?>" method="POST"
                                                                    id="delete" data-title="<?php echo e(__('delete.hub')); ?>">
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class="dropdown-item"><i class="fa fa-trash"
                                                                            aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="table-responsive">
                            <span><?php echo e($hubs->links()); ?></span>
                            <p class="p-2 small">
                                <?php echo __('Showing'); ?>

                                <span class="font-medium"><?php echo e($hubs->firstItem()); ?></span>
                                <?php echo __('to'); ?>

                                <span class="font-medium"><?php echo e($hubs->lastItem()); ?></span>
                                <?php echo __('of'); ?>

                                <span class="font-medium"><?php echo e($hubs->total()); ?></span>
                                <?php echo __('results'); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- end data table  -->
        </div>
    </div>
    <!-- end wrapper  -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/hub/index.blade.php ENDPATH**/ ?>