<?php $__env->startSection('title'); ?>
    <?php echo e(__('asset.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
    <!-- wrapper  -->
    <div class="container-fluid  dashboard-content">
        <!-- pageheader -->
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="page-header">
                    <div class="page-breadcrumb">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>"
                                        class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                                <li class="breadcrumb-item"><a href="javascript:void(0)"
                                        class="breadcrumb-link"><?php echo e(__('levels.asset_management')); ?></a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('asset.index')); ?>"
                                        class="breadcrumb-link"><?php echo e(__('asset.title')); ?></a></li>
                                <li class="breadcrumb-item"><a href=""
                                        class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- end pageheader -->
        <div class="row">
            <!-- table  -->
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="row pl-4 pr-4 pt-4">
                        <div class="col-6">
                            <p class="h3"><?php echo e(__('asset.asset_list')); ?></p>
                        </div>
                        <?php if(hasPermission('assets_create') == true): ?>
                            <div class="col-6">
                                <a href="<?php echo e(route('asset.create')); ?>" class="btn btn-primary btn-sm float-right"
                                    data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i
                                    class="fa fa-plus"></i> <?php echo e(__('levels.add')); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" style="width:100%">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('asset.sl')); ?></th>
                                        <th><?php echo e(__('levels.name')); ?></th>
                                        <th><?php echo e(__('asset.asset_type')); ?></th>
                                        <th><?php echo e(__('asset.assetcategory_id')); ?></th>
                                        <th><?php echo e(__('asset.purchase_date')); ?></th>
                                        <th><?php echo e(__('levels.reminder_to_renew_registration')); ?></th>
                                        <th><?php echo e(__('asset.registration_date')); ?></th>
                                        <th><?php echo e(__('asset.registration_expiry_date')); ?></th>
                                        <th><?php echo e(__('levels.reminder_to_renew_insurance')); ?></th>
                                        
                                        <th><?php echo e(__('asset.insurance_status')); ?></th>
                                        <th><?php echo e(__('levels.insurance_registration')); ?></th>
                                        <th><?php echo e(__('asset.insurance_expiry_date')); ?></th>
                                        <th><?php echo e(__('asset.insurance_amount')); ?></th>
                                        <th><?php echo e(__('asset.maintenance_schedule')); ?></th>
                                        <th><?php echo e(__('asset.amount')); ?></th>
                                        <?php if(hasPermission('assets_update') == true || hasPermission('assets_delete') == true): ?>
                                            <th><?php echo e(__('asset.action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=1; ?>
                                    <?php $__currentLoopData = $assets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $asset): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e(@$asset->name); ?></td>
                                            <td><?php echo e(@$asset->asset_type); ?></td>
                                            <td><?php echo e(@$asset->assetcategorys->title); ?></td>
                                            <td><?php echo e(@$asset->purchase_date); ?></td>
                                            <td><?php echo @$asset->RenewRegistration; ?></td>
                                            <td><?php echo e(@$asset->registration_date); ?></td>
                                            <td><?php echo e(@$asset->registration_expiry_date); ?></td>
                                            <td><?php echo @$asset->RenewInsurance; ?></td>
                                            
                                            <td><?php echo e(@$asset->my_insurance_status); ?></td>
                                            <td><?php echo e(@$asset->insurance_registration); ?></td>
                                            <td><?php echo e(@$asset->insurance_expiry_date); ?></td>
                                            <td><?php echo e(@currency($asset->insurance_amount)); ?></td>
                                            <td><?php echo e(@$asset->maintenance_schedule); ?></td>
                                            <td><?php echo e(currency($asset->amount)); ?></td>
                                            <?php if(hasPermission('assets_update') == true || hasPermission('assets_delete') == true): ?>
                                                <td>
                                                    <div class="row">
                                                        <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split">
                                                            <span class="sr-only">Toggle Dropdown</span>
                                                        </button>
                                                        <div class="dropdown-menu">
                                                            <?php if(hasPermission('assets_read') == true): ?>
                                                                <a href="<?php echo e(route('asset.assign.driver', $asset->id)); ?>" class="dropdown-item"><i class="fas fa-reply"
                                                                    aria-hidden="true"></i> <?php echo e(__('levels.assign')); ?> <?php echo e(__('levels.driver')); ?>

                                                                </a>
                                                            <?php endif; ?>
                                                            <?php if(hasPermission('assets_read') == true): ?>
                                                                <a href="<?php echo e(route('asset.view', $asset->id)); ?>" class="dropdown-item"><i class="fas fa-eye"
                                                                    aria-hidden="true"></i> <?php echo e(__('levels.view')); ?>

                                                                </a>
                                                            <?php endif; ?>
                                                            <?php if(hasPermission('assets_update') == true): ?>
                                                                <a href="<?php echo e(route('asset.edit', $asset->id)); ?>" class="dropdown-item"><i class="fas fa-edit"
                                                                    aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?>

                                                                </a>
                                                            <?php endif; ?>
                                                            <?php if(hasPermission('assets_delete') == true): ?>
                                                                <form id="delete" value="Test" action="<?php echo e(route('asset.delete', $asset->id)); ?>" method="POST" data-title="<?php echo e(__('delete.asset')); ?>">
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <?php echo csrf_field(); ?>
                                                                    <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i>
                                                                        <?php echo e(__('levels.delete')); ?>

                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>
                        </div>
                    </div>

                    <div class="px-3 d-flex flex-row-reverse align-items-center">
                        <span><?php echo e($assets->links()); ?></span>
                        <p class="p-2 small">
                            <?php echo __('Showing'); ?>

                            <span class="font-medium"><?php echo e($assets->firstItem()); ?></span>
                            <?php echo __('to'); ?>

                            <span class="font-medium"><?php echo e($assets->lastItem()); ?></span>
                            <?php echo __('of'); ?>

                            <span class="font-medium"><?php echo e($assets->total()); ?></span>
                            <?php echo __('results'); ?>

                        </p>
                    </div>
                </div>
            </div>
            <!-- end table  -->
        </div>
    </div>
    <!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/asset/index.blade.php ENDPATH**/ ?>