<?php $__env->startSection('title'); ?>
    <?php echo e(__('parcel.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('merchant-panel.parcel.index')); ?>" class="breadcrumb-link"><?php echo e(__('parcel.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- data table  -->
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('merchant-panel.parcel.filter')); ?>"  method="GET">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="form-group col-12 col-md-3 col-sm-6  col-lg-3 col-xl-2">
                                <label for="parcel_date"><?php echo e(__('parcel.date')); ?></label>
                                <input type="text" autocomplete="off" id="date" name="parcel_date" class="form-control date_range_picker" value="<?php echo e(old('parcel_date',$request->parcel_date)); ?>" placeholder="<?php echo e(__('merchantPlaceholder.date')); ?>">
                                <?php $__errorArgs = ['parcel_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-12 col-md-3 col-sm-6  col-lg-3 col-xl-2">
                                <label for="parcelStatus"><?php echo e(__('parcel.status')); ?></label>
                                <select style="width: 100%" id="parcelStatus"  name="parcel_status" class="form-control <?php $__errorArgs = ['parcel_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                                    <option value="" selected> <?php echo e(__('menus.select')); ?> <?php echo e(__('parcel.status')); ?></option>
                                    <?php $__currentLoopData = trans('merchantParcelStatusFilter'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php echo e((old('parcel_status',$request->parcel_status) == $key) ? 'selected' : ''); ?>><?php echo e($status); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['parcel_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-12 col-md-3 col-sm-6  col-lg-3 col-xl-2">
                                <label for="parcel_customer"><?php echo e(__('parcel.customer_name')); ?></label>
                                <input id="parcel_customer" type="text" name="parcel_customer"  placeholder="<?php echo e(__('parcel.customer_name')); ?>" autocomplete="off" class="form-control" value="<?php echo e(old('parcel_customer',$request->parcel_customer)); ?>">
                                <?php $__errorArgs = ['parcel_customer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-12 col-md-3 col-sm-6  col-lg-3 col-xl-2">
                                <label for="parcel_customer_phone"><?php echo e(__('parcel.customer_phone')); ?></label>
                                <input id="parcel_customer_phone" type="text" name="parcel_customer_phone"  placeholder="<?php echo e(__('parcel.customer_phone')); ?>" autocomplete="off" class="form-control" value="<?php echo e(old('parcel_customer_phone',$request->parcel_customer_phone)); ?>">
                                <?php $__errorArgs = ['parcel_customer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-12 col-md-3 col-sm-6 col-lg-3 col-xl-2">
                                <label for="invoice_id"><?php echo e(__('parcel.invoice_id')); ?></label>
                                <input id="invoice_id" type="text" name="invoice_id"  placeholder="<?php echo e(__('parcel.invoice_id')); ?>" autocomplete="off" class="form-control" value="<?php echo e(old('invoice_id',$request->invoice_id)); ?>">
                                <?php $__errorArgs = ['parcel_customer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-3 col-lg-3 col-xl-2">
                                <div class="pt-4 d-flex margin-top-5px">
                                    <button type="submit" class="btn btn-space btn-primary"><i class="fa fa-filter"></i> <?php echo e(__('levels.filter')); ?></button>
                                    <a href="<?php echo e(route('merchant-panel.parcel.index')); ?>" class="btn btn-space btn-secondary"><i class="fa fa-eraser"></i> <?php echo e(__('levels.clear')); ?></a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="row pl-4 pr-4 pt-4 merchantParcelPage">
                    <div class="col-8">
                        <div class="d-flex   parcelsearchFlex parcel-import-export-btn">
                            <p class="h3 mr-5"><?php echo e(__('parcel.title')); ?> </p>
                            <div class="d-flex justify-content-start mt-md-0 d-lg-block   ">
                                <a href="<?php echo e(route('merchant-panel.parcel.file-export',['parcel_date' =>$request->parcel_date, 'parcel_status' => $request->parcel_status,'parcel_customer' => $request->parcel_customer,'parcel_customer_phone' =>$request->parcel_customer_phone])); ?>" class="btn btn-success btn-sm " data-toggle="tooltip" data-placement="top" title="Add"> <i class="fa fa-download"></i> <?php echo e(__('parcel.export_xlsx')); ?></a>
                                <a href="<?php echo e(route('merchant-panel.parcel.file-export',['parcel_date' =>$request->parcel_date, 'parcel_status' => $request->parcel_status,'parcel_customer' => $request->parcel_customer,'parcel_customer_phone' =>$request->parcel_customer_phone,'type'=>'csv'])); ?>" class="btn btn-success btn-sm " data-toggle="tooltip" data-placement="top" title="Add"> <i class="fa fa-download"></i> <?php echo e(__('parcel.export_csv')); ?></a>
                       
                            </div>
                        </div>
                    </div>
                    <div class="col-4 ">
                        <div class="d-flex justify-content-end  mt-0 parcel-create-import-btn-start">
                            
                            <form action="<?php echo e(route('parcel.multiple.print-label')); ?>" method="get" target="_blank" id="print_label_form">
                                <?php echo csrf_field(); ?>
                                <div id="print_label_content"></div>
                                <button type="submit" class="btn btn-sm btn-primary mr-2 multiplelabelprint" data-parcels='' style="display: none"><?php echo e(__('levels.print_label')); ?></button>
                            </form>
                            
                        
                            <a href="<?php echo e(route('merchant-panel.parcel.create')); ?>" class="btn btn-primary btn-sm mr-2" data-toggle="tooltip" data-placement="top" title="Add"><i class="fa fa-plus"></i> <?php echo e(__('levels.add')); ?></a>
                            <a href="<?php echo e(route('merchant-panel.parcel.parcel-import')); ?>" class="btn btn-success btn-sm " data-toggle="tooltip" data-placement="top" title="Add"><i class="fa fa-plus"></i> <?php echo e(__('parcel.import_parcel')); ?></a>
                        </div>
                    </div>
                    <div class="col-12 d-lg-none mt-2 ">
                        <div class="d-flex justify-content-end mt-md-0   ">
                            <a href="<?php echo e(route('merchant-panel.parcel.file-export',['parcel_date' =>$request->parcel_date, 'parcel_status' => $request->parcel_status,'parcel_customer' => $request->parcel_customer,'parcel_customer_phone' =>$request->parcel_customer_phone])); ?>" class="btn btn-success btn-sm " data-toggle="tooltip" data-placement="top" title="Add"> <i class="fa fa-download"></i> <?php echo e(__('parcel.export_xlsx')); ?></a>
                            <a href="<?php echo e(route('merchant-panel.parcel.file-export',['parcel_date' =>$request->parcel_date, 'parcel_status' => $request->parcel_status,'parcel_customer' => $request->parcel_customer,'parcel_customer_phone' =>$request->parcel_customer_phone,'type'=>'csv'])); ?>" class="btn btn-success btn-sm " data-toggle="tooltip" data-placement="top" title="Add"> <i class="fa fa-download"></i> <?php echo e(__('parcel.export_csv')); ?></a>
     
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="table" class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th class="parcel-index permission-check-box">
                                        <input type="checkbox" id="tick-all" class="form-check-input"/> 
                                    </th>
                                    <th><?php echo e(__('###')); ?></th>
                                    <th><?php echo e(__('parcel.tracking_id')); ?></th>
                                    <th><?php echo e(__('parcel.recipient_info')); ?></th>
                                    <th><?php echo e(__('parcel.amount')); ?></th>
                                    <th><?php echo e(__('parcel.status')); ?></th>
                                    <th><?php echo e(__('parcel.payment')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $parcels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="parcel-index permission-check-box">
                                        <input type="checkbox" name="parcels[][<?php echo e($parcel->id); ?>]" value="<?php echo e($parcel->id); ?>" class="common-key form-check-input" />
                                    </td>
                                    <td>
                                        <div class="row">
                                            <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-sm ml-2 bnone">...</button>
                                            <div class="dropdown-menu">
                                                <a href="<?php echo e(route('merchant-panel.parcel.details',$parcel->id)); ?>" class="dropdown-item"><i class="fa fa-eye" aria-hidden="true"></i> <?php echo e(__('levels.view')); ?></a>
                                                <a href="<?php echo e(route('merchant-panel.parcel.logs',$parcel->id)); ?>" class="dropdown-item"><i class="fas fa-history" aria-hidden="true"></i> <?php echo e(__('levels.parcel_logs')); ?></a>
                                                <a href="<?php echo e(route('merchant-parcel.clone',$parcel->id)); ?>" class="dropdown-item"><i class="fas fa-clone" aria-hidden="true"></i> <?php echo e(__('levels.clone')); ?></a>
                                                <?php if( \App\Enums\ParcelStatus::DELIVERED !== $parcel->status): ?>
                                                    <?php if($parcel->status == App\Enums\ParcelStatus::PENDING): ?>
                                                        <a href="<?php echo e(route('merchant-panel.parcel.edit',$parcel->id)); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                        <form id="delete" value="Test" action="<?php echo e(route('merchant-panel.parcel.delete',$parcel->id)); ?>" method="POST" data-title="<?php echo e(__('delete.parcel')); ?>">
                                                            <?php echo method_field('DELETE'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="" value="Parcel" id="deleteTitle">
                                                            <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                        </form>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e($parcel->tracking_id); ?></td>
                                    <td class="merchantpayment">
                                        <div class="w150">
                                            <div class="d-flex">
                                                <i class="fa fa-user"></i>&nbsp;<p><?php echo e($parcel->customer_name); ?></p>
                                            </div>
                                            <div class="d-flex">
                                                <i class="fas fa-phone"></i>&nbsp;<p><?php echo e($parcel->customer_phone); ?></p>
                                            </div>
                                            <div class="d-flex">
                                                <i class="fas fa-map-marker-alt"></i>&nbsp;<p><?php echo e($parcel->customer_address); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="w250">
                                            <?php echo e(__('levels.cod')); ?>: <span class="text-dark"><?php echo e(settings()->currency); ?><?php echo e($parcel->cash_collection); ?></span>
                                            <br>
                                            <?php if($parcel->return_to_courier == App\Enums\BooleanStatus::YES): ?> 
                                                <?php echo e(__('levels.return_charges')); ?>: <span class="text-dark"><?php echo e(settings()->currency); ?><?php echo e($parcel->return_charges); ?></span>
                                                <br>
                                            <?php else: ?>
                                                <?php echo e(__('levels.total_delivery_amount')); ?>: <span class="text-dark"><?php echo e(settings()->currency); ?><?php echo e($parcel->total_delivery_amount); ?></span>
                                                <br>
                                                <?php echo e(__('levels.vat_amount')); ?>: <span class="text-dark"><?php echo e(settings()->currency); ?><?php echo e($parcel->vat_amount); ?></span>
                                                <br>
                                            <?php endif; ?>
                                            <?php echo e(__('levels.current_payable')); ?>: <b><?php echo e(settings()->currency); ?><?php echo e($parcel->current_payable); ?></b>
                                            <br>
                                        </div>
                                    </td>
                                     <td>
                                        <p><?php echo $parcel->parcel_status; ?></p>
                                        <span><?php echo e(__('parcel.updated_on')); ?>: <?php echo e(\Carbon\Carbon::parse($parcel->updated_at)->format('Y-m-d h:i:s A')); ?></span>
                                    </td>
                                    <td> 
                                        <?php if($parcel->invoice): ?>     
                                            <p><?php echo e(__('invoice.'.@$parcel->invoice->status)); ?></p> 
                                            <?php echo e(@$parcel->invoice->invoice_id); ?><br/>
                                            <?php if($parcel->invoice->status == App\Enums\InvoiceStatus::PAID): ?>
                                                    Paid At: <?php echo e(@dateFormat(@$parcel->invoice->updated_at)); ?>

                                            <?php endif; ?>
                                        <?php else: ?>
                                            N/A 
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="px-3 d-flex flex-row-reverse align-items-center">
                    <span><?php echo e($parcels->appends($request->all())->links()); ?></span>
                    <p class="p-2 small">
                        <?php echo __('Showing'); ?>

                        <span class="font-medium"><?php echo e($parcels->firstItem()); ?></span>
                        <?php echo __('to'); ?>

                        <span class="font-medium"><?php echo e($parcels->lastItem()); ?></span>
                        <?php echo __('of'); ?>

                        <span class="font-medium"><?php echo e($parcels->total()); ?></span>
                        <?php echo __('results'); ?>

                    </p>
                </div>
            </div>
        </div>
        <!-- end data table  -->
    </div>
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>
<!-- css  -->
<?php $__env->startPush('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<?php $__env->stopPush(); ?>
<!-- js  -->
<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script type="text/javascript" src="<?php echo e(static_asset('backend/js/date-range-picker/date-range-picker-custom.js')); ?>"></script>
    <script>
        var dateParcel = '<?php echo e($request->parcel_date); ?>';
    </script>
    <script src="<?php echo e(static_asset('backend/js/merchant_panel/parcel/filter.js')); ?>"></script>
    <script src="<?php echo e(static_asset('backend/js/parcel/parcel-search.js')); ?>"></script>

    <script type="text/javascript">
            $(document).ready(function(){
                
                    //multiple parcel label print 
                    $('#tick-all').on('change', function(){  
                        if(!$(this).is(':checked')){ 
                            $('td').closest('tr').find('.common-key').prop('checked', false)
                        }
                        else{ 
                            if ($(this).is(':checked')) {
                                $('td').closest('tr').find('.common-key').prop('checked', true)
                            } 
                        } 
                        showPrintBtn();
                    }); 

                    $('.common-key').on('click',function(){
                        showPrintBtn();
                    })

                    function showPrintBtn(){
                        if($('.common-key:checked').length > 0){
                            $('.multiplelabelprint').show();
                            var inputs   ='';
                            $('.common-key:checked').each(function(){ 
                                inputs += '<input type="hidden" name="parcels[]" value="'+$(this).val()+'"/>';
                            });
                            $('#print_label_content').html(inputs);
                        }else{
                            $('.multiplelabelprint').hide();
                            $('#tick-all').prop('checked', false);
                            $('#print_label_content').html('');
                        }
                    }

                    //multiple parcel label print
            });
    </script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/merchant_panel/parcel/index.blade.php ENDPATH**/ ?>