<?php $__env->startSection('title'); ?>
    <?php echo e(__('merchant.title')); ?>  <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link"><?php echo e(__('merchantmanage.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('merchant.index')); ?>" class="breadcrumb-link"><?php echo e(__('merchant.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- data table  -->
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-10">
                        <div class="d-flex parcelsearchFlex">
                            <p class="h3"><?php echo e(__('merchant.title')); ?></p>
                            <input id="Psearch" class="form-control parcelSearch d-lg-block" type="text" placeholder="Search..">
                        </div>
                    </div>
                    <?php if( hasPermission('merchant_create') == true ): ?>
                    <div class="col-2">
                        <a href="<?php echo e(route('merchant.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                    </div>
                    <?php endif; ?>
                    <div class="col-12 d-lg-none mt-2">
                        <input id="Psearch" class="form-control " type="text" placeholder="Search..">
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="table" class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('levels.details')); ?></th>
                                    <th><?php echo e(__('levels.hub')); ?></th>
                                    <th><?php echo e(__('levels.business_name')); ?></th>
                                    <th><?php echo e(__('levels.unique_id')); ?></th>
                                    <th><?php echo e(__('levels.phone')); ?></th>
                                    <th><?php echo e(__('levels.status')); ?></th>
                                    <th><?php echo e(__('levels.current_balance')); ?></th>
                                    <?php if(
                                     hasPermission('merchant_view') == true ||
                                     hasPermission('merchant_update') == true ||
                                     hasPermission('merchant_delete') == true
                                     ): ?>
                                    <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?> 
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $merchants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $merchant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td>
                                        <div class="row">
                                            <div class="pr-3">
                                                <img src="<?php echo e($merchant->user->image); ?>" alt="user" class="rounded" width="40" height="40">
                                            </div>
                                            <div>
                                                <strong><?php echo e($merchant->user->name); ?></strong>
                                                <p><?php echo e($merchant->user->email); ?></p>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo e(@$merchant->user->hub->name); ?></td>
                                    <td><?php echo e(@$merchant->business_name); ?></td>
                                    <td><?php echo e(@$merchant->merchant_unique_id); ?></td>
                                    <td><?php echo e(@$merchant->user->mobile); ?></td>
                                    <td><?php echo $merchant->user->my_status; ?></td>
                                    <td><?php echo e(settings()->currency); ?><?php echo e($merchant->current_balance); ?></td>
                                    <?php if(
                                        hasPermission('merchant_view') == true ||
                                        hasPermission('merchant_update') == true ||
                                        hasPermission('merchant_delete') == true
                                        ): ?>
                                        <td>
                                            <div class="row">
                                                <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                                <div class="dropdown-menu">
                                                    <a href="<?php echo e(route('merchant.invoice.generate',$merchant->id)); ?>" class="dropdown-item"><i class="fa fa-file" aria-hidden="true"></i> Invoice Generate</a>
                                                    <?php if( hasPermission('merchant_view') == true  ): ?>
                                                        <a href="<?php echo e(route('merchant.view',$merchant->id)); ?>" class="dropdown-item"><i class="fa fa-eye" aria-hidden="true"></i> <?php echo e(__('levels.view')); ?></a>
                                                    <?php endif; ?>
                                                    <?php if( hasPermission('merchant_update') == true   ): ?>
                                                        <a href="<?php echo e(route('merchant.edit',$merchant->id)); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                    <?php endif; ?>
                                                    <?php if( hasPermission('merchant_delete') == true ): ?>
                                                        <form id="delete" value="Test" action="<?php echo e(route('merchant.delete',$merchant->id)); ?>" method="POST" data-title="<?php echo e(__('delete.merchant')); ?>">
                                                            <?php echo method_field('DELETE'); ?>
                                                            <?php echo csrf_field(); ?>
                                                            <input type="hidden" name="" value="Merchant" id="deleteTitle">
                                                            <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                        </form>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                     
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="px-3 d-flex flex-row-reverse align-items-center">
                        <span><?php echo e($merchants->links()); ?></span>
                        <p class="p-2 small">
                            <?php echo __('Showing'); ?>

                            <span class="font-medium"><?php echo e($merchants->firstItem()); ?></span>
                            <?php echo __('to'); ?>

                            <span class="font-medium"><?php echo e($merchants->lastItem()); ?></span>
                            <?php echo __('of'); ?>

                            <span class="font-medium"><?php echo e($merchants->total()); ?></span>
                            <?php echo __('results'); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- end data table  -->
    </div>
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>
<!-- js  -->
<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(static_asset('backend/js/parcel/parcel-search.js')); ?>"></script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/merchant/index.blade.php ENDPATH**/ ?>