<?php $__env->startSection('title'); ?>
    <?php echo e(__('permissions.cash_received_from_delivery_man')); ?> <?php echo e(__('levels.add')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link"><?php echo e(__('account.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('cash.received.deliveryman.index')); ?>" class="breadcrumb-link"><?php echo e(__('permissions.cash_received_from_delivery_man')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link active"><?php echo e(__('levels.create')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- basic form -->
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h2 class="pageheader-title"><?php echo e(__('levels.create')); ?></h2>
                    <form action="<?php echo e(route('cash.received.deliveryman.store')); ?>"  method="POST" enctype="multipart/form-data" id="basicform">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group delivery_man_search">
                                    <label for="parcelDeliveryManID_"><?php echo e(__('parcel.deliveryman')); ?></label> <span class="text-danger">*</span>
                                    <select style="width: 100%" id="parcelDeliveryManID_"  name="delivery_man_id" data-url="<?php echo e(route('parcel.deliveryman.search')); ?>" class="form-control <?php $__errorArgs = ['delivery_man_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value=""> <?php echo e(__('Select Delivery Man')); ?></option>
                                    </select>
                                    <input type="hidden" id="deliveryman_amount" value="0"/>
                                    <div  class="deliveryman_balance active"></div>
                                    <?php $__errorArgs = ['delivery_man_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="date"><?php echo e(__('levels.date')); ?></label> <span class="text-danger">*</span>
                                    <input type="text" id="date" data-toggle="datepicker" name="date" data-parsley-trigger="change" placeholder="yyyy-mm-dd"  class="form-control" value="<?php echo e(old('date',date('Y-m-d'))); ?>" required>
                                    <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="receipt"><?php echo e(__('levels.receipt')); ?></label>
                                    <input id="receipt" type="file" name="receipt" data-parsley-trigger="change" placeholder="Enter receipt" autocomplete="off" class="form-control" value="<?php echo e(old('receipt')); ?>" require>
                                    <?php $__errorArgs = ['receipt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group">
                                    <label for="account_ids"><?php echo e(__('levels.to_account')); ?></label> <span class="text-danger">*</span>
                                    <select id="account_ids" name="account_id" class="form-control" required>
                                        <option selected disabled>Select</option>
                                        <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e((old('account_id') == $account->id) ? 'selected' : ''); ?> value="<?php echo e($account->id); ?>">
                                                <?php if($account->gateway == 1): ?>
                                                    <?php echo e($account->user->name); ?> (Cash)
                                                <?php else: ?>
                                                    <?php if($account->gateway == 3): ?>
                                                        bKash ,
                                                    <?php elseif($account->gateway == 4): ?>
                                                        Rocket ,
                                                    <?php elseif($account->gateway == 5): ?>
                                                        Nagad ,
                                                    <?php endif; ?>
                                                    <?php echo e($account->account_holder_name); ?>

                                                    (<?php echo e($account->account_no); ?>

                                                    <?php echo e($account->branch_name); ?>

                                                    <?php echo e($account->mobile); ?>)
                                                <?php endif; ?>
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <div class="text-danger mt-2" id="account_balance_"><?php echo e(old('account_balance')); ?></div>
                                    <input type="hidden" name="account_balance" value="<?php echo e(old('account_balance')); ?>" id="account_balance">
                                    <?php $__errorArgs = ['account_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group amount_divs">
                                    <label for="amount"><?php echo e(__('levels.amount')); ?></label> <span class="text-danger">*</span>
                                    <div class="form-control-wrap">
                                        <input type="number" class="form-control cash-collection" id="amount" value="<?php echo e(old('amount')); ?>" name="amount" placeholder="Enter Amount" required>
                                        <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <small class="text-danger mt-2"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <small class="check_message text-danger"></small>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="note"><?php echo e(__('levels.note')); ?></label>
                                    <div class="form-control-wrap deliveryman-search">
                                       <textarea class="form-control" name="note" rows="5"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 ">
                                <button type="submit" class="btn btn-space btn-primary"><?php echo e(__('levels.save')); ?></button>
                                <a href="<?php echo e(route('cash.received.deliveryman.index')); ?>" class="btn btn-space btn-secondary"><?php echo e(__('levels.cancel')); ?></a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- end basic form -->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        var merchantUrl = '<?php echo e(route('parcel.merchant.get')); ?>';
        var hubUrl      = '<?php echo e(route('parcel.hub.get')); ?>';
    </script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(static_asset('backend/js/hub_panel/received_from_delivery_man/custom.js')); ?>"></script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/hub_panel/cash_received_from_deliveryman/create.blade.php ENDPATH**/ ?>