<?php $__env->startSection('title'); ?>
    <?php echo e(__('permissions.cash_received_from_delivery_man')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link"><?php echo e(__('account.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link"><?php echo e(__('permissions.cash_received_from_delivery_man')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- table  -->
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-6">
                        <p class="h3"><?php echo e(__('permissions.cash_received_from_delivery_man')); ?></p>
                    </div>
                    <?php if(hasPermission('cash_received_from_delivery_man_create') == true ): ?>
                        <div class="col-6">
                            <a href="<?php echo e(route('cash.received.deliveryman.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('levels.details')); ?></th>
                                    <th><?php echo e(__('levels.hub')); ?></th>
                                    <th><?php echo e(__('levels.to_account')); ?></th>
                                    <th><?php echo e(__('levels.date')); ?></th>
                                    <th><?php echo e(__('levels.receipt')); ?></th>
                                    <th><?php echo e(__('levels.amount')); ?></th>
                                    <?php if(
                                        hasPermission('cash_received_from_delivery_man_update') == true ||
                                        hasPermission('cash_received_from_delivery_man_delete') == true
                                    ): ?>
                                        <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $i=0;
                                ?>
                                <?php $__currentLoopData = $hubStatements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$i); ?></td>
                                        <td>
                                            <div class="row ">
                                                <span class="col-12">
                                                    <?php echo e(__('parcel.deliveryman')); ?>

                                                </span>
                                            </div>
                                            <?php if($statement->delivery_man_id != null): ?>
                                                <div class="row  ">
                                                    <span class="col-5"><?php echo e(__('levels.name')); ?></span>
                                                    <span class="col-7">: <?php echo e($statement->deliveryman->user->name); ?></span>
                                                </div>
                                                <div class="row  ">
                                                    <span class="col-5"><?php echo e(__('levels.mobile')); ?></span>
                                                    <span class="col-7">: <?php echo e($statement->deliveryman->user->mobile); ?></span>
                                                </div>
                                            <?php endif; ?>
                                            <div class="row  ">
                                                <span class="col-5"><?php echo e(__('levels.note')); ?></span>
                                                <span class="col-7">: <?php echo e(@$statement->note); ?></span>
                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e($statement->user->hub->name); ?><br/>
                                            <?php echo e($statement->user->hub->phone); ?><br/>
                                            <?php echo e($statement->user->hub->address); ?><br/>
                                        </td>
                                        <td>
                                            <?php echo e($statement->account->account_holder_name); ?><br>
                                            <?php echo e($statement->account->account_no); ?><br>
                                            <?php echo e($statement->account->branch_name); ?>

                                        </td>
                                        <td><?php echo e(dateFormat($statement->date)); ?></td>

                                        <td>
                                            <a href="<?php echo e(static_asset($statement->upload->original)); ?>" download="" >Download</a>
                                        </td>
                                        <td><?php echo e(settings()->currency); ?><?php echo e($statement->amount); ?></td>
                                        <?php if(
                                            hasPermission('cash_received_from_delivery_man_update') == true ||
                                            hasPermission('cash_received_from_delivery_man_delete') == true
                                        ): ?>
                                            <td>
                                                <div class="row">
                                                    <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                                    <div class="dropdown-menu">
                                                        <?php if(hasPermission('cash_received_from_delivery_man_update') == true  ): ?>
                                                            <a href="<?php echo e(route('cash.received.deliveryman.edit',$statement->id)); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                        <?php endif; ?>
                                                        <?php if(hasPermission('cash_received_from_delivery_man_delete') == true  ): ?>
                                                            <form id="delete" action="<?php echo e(route('cash.received.deliveryman.delete',$statement->id)); ?>" method="POST" data-title="<?php echo e(__('delete.cash_received')); ?>">
                                                                <?php echo method_field('DELETE'); ?>
                                                                <?php echo csrf_field(); ?>
                                                                <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                            </form>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- end table  -->
    </div>
</div>
<!-- end wrapper  --> 

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/hub_panel/cash_received_from_deliveryman/index.blade.php ENDPATH**/ ?>