<?php $__env->startSection('title'); ?>
    <?php echo e(__('levels.maintenance')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
    <!-- wrapper  -->
    <div class="container-fluid  dashboard-content">
        <!-- pageheader -->
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="page-header">
                    <div class="page-breadcrumb">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                                <li class="breadcrumb-item"><a href="#" class="breadcrumb-link"><?php echo e(__('menus.asset_management')); ?></a></li>
                                <li class="breadcrumb-item"><a href="" class="breadcrumb-link"><?php echo e(__('levels.maintenances')); ?></a></li>
                                <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- end pageheader -->
        <div class="row">
            <!-- data table  -->
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="card">
                    <div class="row pl-4 pr-4 pt-4">
                        <div class="col-6">
                            <p class="h3"><?php echo e(__('levels.maintenances')); ?></p>
                        </div>
                        <?php if(hasPermission('maintenance_create') == true): ?>
                            <div class="col-6">
                                <a href="<?php echo e(route('maintenance.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table" style="width:100%">
                                <thead>
                                    <tr> 
                                        <th><?php echo e(__('levels.id')); ?></th> 
                                        <th><?php echo e(__('asset.asset')); ?></th>
                                        <th><?php echo e(__('levels.start_date')); ?></th>
                                        <th><?php echo e(__('levels.end_date')); ?></th>
                                        <th><?php echo e(__('levels.due_days')); ?></th> 
                                        <th><?php echo e(__('levels.repair_details')); ?></th>
                                        <th><?php echo e(__('levels.spare_parts_purchased_details')); ?></th> 
                                        <th><?php echo e(__('levels.invoice_of_the_purchases')); ?></th> 
                                        <?php if(hasPermission('maintenance_update') == true || hasPermission('maintenance_delete') == true): ?>
                                            <th><?php echo e(__('levels.actions')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=1; ?>
                                    <?php $__currentLoopData = $maintenances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $maintenance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e(@$maintenance->asset->name); ?></td>
                                            <td><?php echo e($maintenance->start_date); ?></td>
                                            <td><?php echo e($maintenance->end_date); ?></td>
                                            <td><?php echo e($maintenance->DueDays['due_days']); ?> Due Days / <?php echo e($maintenance->DueDays['total_days']); ?> Days</td> 
                                            <td><?php echo e($maintenance->repair_details); ?></td>
                                            <td><?php echo e($maintenance->spare_parts_purchased_details); ?></td>
                                            <td><a href="<?php echo e($maintenance->MyInvoiceOfThePurchases); ?>" download="">Download</a></td>  
                                            <?php if(hasPermission('maintenance_update') == true || hasPermission('maintenance_delete') == true): ?>
                                                <td>
                                                    <div class="row">
                                                        <button tabindex="-1" data-toggle="dropdown" type="button"
                                                            class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span
                                                                class="sr-only">Toggle Dropdown</span></button>
                                                        <div class="dropdown-menu">
                                                            <?php if(hasPermission('maintenance_update') == true): ?>
                                                                <a href="<?php echo e(route('maintenance.edit', $maintenance->id)); ?>"
                                                                    class="dropdown-item"><i class="fas fa-edit"
                                                                        aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if(hasPermission('maintenance_delete') == true): ?>
                                                                <form id="delete" value="Test"
                                                                    action="<?php echo e(route('maintenance.delete', $maintenance->id)); ?>"
                                                                    method="POST" data-title="<?php echo e(__('delete.maintenance')); ?>">
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name=""
                                                                        value="<?php echo e(__('levels.maintenance')); ?>" id="deleteTitle">
                                                                    <button type="submit" class="dropdown-item"><i
                                                                            class="fa fa-trash" aria-hidden="true"></i>
                                                                        <?php echo e(__('levels.delete')); ?></button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </td>
                                            <?php endif; ?>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="px-3 d-flex flex-row-reverse align-items-center">
                        <span><?php echo e($maintenances->links()); ?></span>
                        <p class="p-2 small">
                            <?php echo __('Showing'); ?>

                            <span class="font-medium"><?php echo e($maintenances->firstItem()); ?></span>
                            <?php echo __('to'); ?>

                            <span class="font-medium"><?php echo e($maintenances->lastItem()); ?></span>
                            <?php echo __('of'); ?>

                            <span class="font-medium"><?php echo e($maintenances->total()); ?></span>
                            <?php echo __('results'); ?>

                        </p>
                    </div>
                </div>
            </div>
            <!-- end data table  -->
        </div>
    </div>
    <!-- end wrapper  -->
<?php $__env->stopSection(); ?>
 
<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/maintenance/index.blade.php ENDPATH**/ ?>