<?php $__env->startSection('title'); ?>
    <?php echo e(__('hub_payment.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link"><?php echo e(__('hub.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <!-- data table  -->
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-8">
                        <p class="h3"><?php echo e(__('hub.title')); ?> <?php echo e(__('hub_payment.payment')); ?> <?php echo e(__('levels.list')); ?></p>
                    </div>
                    <?php if(hasPermission('hub_payment_create') == true): ?>
                    <div class="col-4">
                        <a href="<?php echo e(route('hub.hub-payment.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('hub_payment.details')); ?></th>
                                    <th><?php echo e(__('hub_payment.transaction_id')); ?></th>
                                    <th><?php echo e(__('hub_payment.reference')); ?></th>
                                    <th><?php echo e(__('hub_payment.description')); ?></th>
                                    <th><?php echo e(__('hub_payment.amount')); ?></th>
                                    <th><?php echo e(__('levels.status')); ?></th>

                                <?php if(
                                        hasPermission('hub_payment_reject') == true ||
                                        hasPermission('hub_payment_process') == true ||
                                        hasPermission('hub_payment_update') == true ||
                                        hasPermission('hub_payment_delete') == true
                                     ): ?>
                                    <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>

                                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td>
                                        <?php if($payment->frompayment !==null && $payment->frompayment->gateway == 1): ?>
                                            Cash
                                        <?php elseif($payment->frompayment !==null && $payment->frompayment->gateway == 2): ?>
                                            <?php echo e(@$payment->frompayment->account_holder_name); ?><br/>
                                            <?php echo e(@$payment->frompayment->account_no); ?><br/>
                                            <?php echo e(@$payment->frompayment->branch_name); ?>

                                        <?php elseif(
                                            $payment->frompayment !==null &&
                                            @$payment->frompayment->gateway == 3 ||
                                            @$payment->frompayment->gateway == 4 ||
                                            @$payment->frompayment->gateway == 5
                                        ): ?>
                                            <?php if($payment->frompayment->gateway == 3): ?>
                                                Bkash
                                            <?php elseif($payment->frompayment->gateway == 4): ?>
                                                Rocket
                                            <?php elseif($payment->frompayment->gateway == 5): ?>
                                                Nagad
                                            <?php endif; ?> <br/>
                                            <?php echo e(@$payment->frompayment->account_holder_name); ?><br/>
                                            <?php echo e(@$payment->frompayment->mobile); ?><br/>
                                            <?php if($payment->frompayment->account_type == 1): ?>
                                                Merchant
                                            <?php else: ?>
                                                Persional
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($payment->transaction_id); ?></td>
                                    <td><?php if(isset($payment->referencefile)): ?><a href="<?php echo e(static_asset($payment->referencefile->original)); ?>" download="">Download</a><?php endif; ?></td>

                                    <td><?php echo e(\Str::limit($payment->description,100,' ...')); ?></td>
                                    <td><?php echo e(settings()->currency); ?><?php echo e($payment->amount); ?></td>
                                    <td>
                                        <?php if($payment->status == \App\Enums\ApprovalStatus::REJECT): ?>
                                        <span class="badge badge-pill badge-danger"><?php echo e(trans('approvalstatus.'.\App\Enums\ApprovalStatus::REJECT)); ?></span>
                                        <?php elseif($payment->status == \App\Enums\ApprovalStatus::PENDING): ?>
                                        <span class="badge badge-pill badge-warning"><?php echo e(trans('approvalstatus.'.\App\Enums\ApprovalStatus::PENDING)); ?></span>
                                        <?php elseif($payment->status == \App\Enums\ApprovalStatus::PROCESSED): ?>
                                        <span class="badge badge-pill badge-success"><?php echo e(trans('approvalstatus.'.\App\Enums\ApprovalStatus::PROCESSED)); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <?php if(
                                        hasPermission('hub_payment_reject') == true ||
                                        hasPermission('hub_payment_process') == true ||
                                        hasPermission('hub_payment_update') == true ||
                                        hasPermission('hub_payment_delete') == true
                                     ): ?>
                                        <td>
                                            <?php if($payment->status == \App\Enums\ApprovalStatus::PROCESSED || $payment->status == \App\Enums\ApprovalStatus::REJECT ): ?>
                                                <div class="row">
                                                    <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                                    <div class="dropdown-menu">
                                                        <?php if( $payment->status == \App\Enums\ApprovalStatus::PROCESSED): ?>
                                                            <a href="<?php echo e(route('hub-payment.cancel-process',$payment->id)); ?>" class="dropdown-item"><i class="fas fa-check" aria-hidden="true"></i> <?php echo e(__('levels.cancel_process')); ?></a>
                                                        <?php else: ?>
                                                            <a href="<?php echo e(route('hub-payment.cancel-reject',$payment->id)); ?>" class="dropdown-item"><i class="fas fa-ban" aria-hidden="true"></i> <?php echo e(__('levels.cancel_reject')); ?></a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <div class="row">
                                                    <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                                    <div class="dropdown-menu">
                                                        <?php if( $payment->status == \App\Enums\ApprovalStatus::PENDING): ?>
                                                            <?php if(  hasPermission('hub_payment_reject') == true  ): ?>
                                                                <a href="<?php echo e(route('hub-payment.reject',$payment->id)); ?>" class="dropdown-item"><i class="fas fa-ban" aria-hidden="true"></i> <?php echo e(__('levels.reject')); ?></a>
                                                            <?php endif; ?>
                                                            <?php if( hasPermission('hub_payment_process') == true  ): ?>
                                                                <a href="<?php echo e(route('hub-payment.process',$payment->id)); ?>" class="dropdown-item"><i class="fas fa-check" aria-hidden="true"></i> <?php echo e(__('levels.process')); ?></a>
                                                            <?php endif; ?>
                                                                <?php if( hasPermission('hub_payment_update') == true  ): ?>
                                                                    <a href="<?php echo e(route('hub.hub-payment.edit',$payment->id)); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                                <?php endif; ?>
                                                                <?php if(  hasPermission('hub_payment_delete') == true   ): ?>
                                                                    <form id="delete" value="Test" action="<?php echo e(route('hub.hub-payment.delete',$payment->id)); ?>" method="POST" data-title="<?php echo e(__('delete.hub_payment')); ?>">
                                                                        <?php echo method_field('DELETE'); ?>
                                                                        <?php echo csrf_field(); ?>
                                                                        <input type="hidden" name="" value="Payment" id="deleteTitle">
                                                                        <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                                    </form>
                                                                <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>

                        </table>

                        <div class="px-3 d-flex flex-row-reverse align-items-center">
                            <span><?php echo e($payments->links()); ?></span>
                            <p class="p-2 small">
                                <?php echo __('Showing'); ?>

                                <span class="font-medium"><?php echo e($payments->firstItem()); ?></span>
                                <?php echo __('to'); ?>

                                <span class="font-medium"><?php echo e($payments->lastItem()); ?></span>
                                <?php echo __('of'); ?>

                                <span class="font-medium"><?php echo e($payments->total()); ?></span>
                                <?php echo __('results'); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end data table  -->
    </div>
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/hub_payment/index.blade.php ENDPATH**/ ?>