<?php $__env->startSection('title'); ?>
   <?php echo e(__('role.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<div class="container-fluid  dashboard-content">
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="#" class="breadcrumb-link"><?php echo e(__('menus.user_role')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('roles.index')); ?>" class="breadcrumb-link"><?php echo e(__('role.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-6">
                        <p class="h3"><?php echo e(__('role.title')); ?></p>
                    </div>
                    <?php if(hasPermission('role_create') == true): ?>
                    <div class="col-6">
                        <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('levels.name')); ?></th>
                                    <th><?php echo e(__('levels.slug')); ?></th>
                                    <th><?php echo e(__('levels.permission')); ?></th>
                                    <th><?php echo e(__('levels.status')); ?></th>

                                    <?php if(hasPermission('role_update') == true || hasPermission('role_delete') == true): ?>
                                    <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td><?php echo e($role->name); ?></td>
                                    <td><?php echo e($role->slug); ?></td>
                                    <td>
                                        <?php if(!empty($role->permissions) ): ?>
                                                <label class="badge badge-primary"><?php echo e(count($role->permissions)); ?></label>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo $role->my_status; ?></td>
                                    <?php if(hasPermission('role_update') == true || hasPermission('role_delete') == true ): ?>
                                    <td>
                                        <div class="row">
                                            <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                            <div class="dropdown-menu">
                                                <?php if(hasPermission('role_update') == true ): ?>
                                                    <a href="<?php echo e(route('roles.edit',$role->id)); ?>" class="dropdown-item"><i class="fas fa-edit" aria-hidden="true"></i> <?php echo e(__('levels.edit')); ?></a>
                                                <?php endif; ?>
                                                <?php if( hasPermission('role_delete') == true ): ?>
                                                    <form action="<?php echo e(route('role.delete',$role->id)); ?>" method="POST" id="delete" data-title="<?php echo e(__('delete.role')); ?>">
                                                        <?php echo method_field('DELETE'); ?>
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit"  class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                    </form>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="px-3 d-flex flex-row-reverse align-items-center">
                    <span><?php echo e($roles->links()); ?></span>
                    <p class="p-2 small">
                        <?php echo __('Showing'); ?>

                        <span class="font-medium"><?php echo e($roles->firstItem()); ?></span>
                        <?php echo __('to'); ?>

                        <span class="font-medium"><?php echo e($roles->lastItem()); ?></span>
                        <?php echo __('of'); ?>

                        <span class="font-medium"><?php echo e($roles->total()); ?></span>
                        <?php echo __('results'); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/role/index.blade.php ENDPATH**/ ?>