<?php $__env->startSection('title'); ?>
    <?php echo e(__('menus.dashboard')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
    <div class="container-fluid dashboard-content ">

        <!-- pageheader  -->
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="page-header">
                    <div class="page-breadcrumb">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>"
                                        class="breadcrumb-link"><?php echo e(__('menus.dashboard')); ?></a></li>
                                <li class="breadcrumb-item active" aria-current="page"><?php echo e(settings()->name); ?>

                                    <?php echo e(__('menus.dashboard')); ?> </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
        <!-- end pageheader  -->
        <div class="ecommerce-widget">

            <div class="row ">
                <div class="col-lg-12 dashboard-filter mb-3">
                    <form action="<?php echo e(route('dashboard.index', ['test' => 'custom'])); ?>" method="get">
                        <button type="submit" class="btn btn-sm btn-primary float-right group-btn ml-0"
                            style="margin-left: 0px"><?php echo e(__('levels.filter')); ?></button>
                        <input type="hidden" name="days" value="custom" />
                        <input type="text" name="filter_date" placeholder="YYYY-MM-DD" autocomplete="off"
                            class="form-control dashboard-filter-input date_range_picker float-right group-input"
                            value="<?php echo e($request->filter_date); ?>" style="width: 15%;" required />
                    </form>

                </div>
            </div>
            <div class="row header-summery">


                <?php if(hasPermission('total_parcel') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('parcel.filter',['parcel_date' => $request->date])); ?>" class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color  ">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex">
                                        <label class="icon p-10px">
                                            <i class="fa fa-box-open"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_parcel')); ?></h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_parcel']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>

                <?php if(hasPermission('total_user') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="card border-3 border-top border-top-primary total-card-color  ">
                            <a href="<?php echo e(route('users.filter',['date' => $request->date])); ?>" class="d-block">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex  ">
                                        <label class="icon p-10px">
                                            <i class="fa fa-users"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_user')); ?> </h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_user']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(hasPermission('total_merchant') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('merchant.index',['date' => $request->date])); ?>" class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color  ">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex">
                                        <label class="icon p-10px">
                                            <i class="fa fa-users"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_merchant')); ?></h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_merchant']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>


                <?php if(hasPermission('total_delivery_man') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('deliveryman.index',['date' => $request->date])); ?>" class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color  ">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex">
                                        <label class="icon p-10px">
                                            <i class="fas fa-users"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_delivery_man')); ?></h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_delivery_man']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>


                <?php if(hasPermission('total_hubs') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('hubs.filter',['date' => $request->date])); ?>" class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color  ">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex">
                                        <label class="icon p-10px">
                                            <i class="fas fa-warehouse"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_hubs')); ?></h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_hubs']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>


                <?php if(hasPermission('total_accounts') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('accounts.index',['date' => $request->date])); ?>" class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color  ">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex">
                                        <label class="icon p-10px">
                                            <i class="fa fa-credit-card"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_accounts')); ?></h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_accounts']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>

                <?php if(hasPermission('total_partial_deliverd') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('parcel.filter', ['parcel_status' => \App\Enums\ParcelStatus::PARTIAL_DELIVERED,'parcel_date'=>$request->date])); ?>"
                            class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color ">
                                <div class="card-body total-card-body">
                                    <div class="text-center total-card d-flex">
                                        <label class="icon p-10px">
                                            <i class="fas fa-handshake"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_partial_deliverd')); ?> </h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_partial_deliverd']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>

                <?php if(hasPermission('total_parcels_deliverd') == true): ?>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <a href="<?php echo e(route('parcel.filter', ['parcel_status' => \App\Enums\ParcelStatus::DELIVERED,'parcel_date'=>$request->date])); ?>"
                            class="d-block">
                            <div class="card border-3 border-top border-top-primary total-card-color ">
                                <div class="card-body total-card-body">
                                    <div class="text-center d-flex">
                                        <label class="icon p-10px">
                                            <i class="fas fa-handshake"></i>
                                        </label>
                                        <div class="box-content w-100 text-left">
                                            <h5 class="text-muted"><?php echo e(__('dashboard.total_deliverd')); ?></h5>
                                            <div class="metric-value d-inline-block">
                                                <h1 class="mb-1"><?php echo e($data['total_deliverd']); ?></h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>


            </div>
            

            <?php if(hasPermission('all_statements') == true): ?>
                <div class="row mb-4">
                    <div class="col-md-4">
                        <ul class="list-group mt-2">
                            <li class="list-group-item profile-list-group-item text-center">
                                <span class="font-weight-bold "> <?php echo e(__('dashboard.delivery_man')); ?>

                                    <?php echo e(__('dashboard.statements')); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"> <?php echo e(__('income.title')); ?> </span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($d_income); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"><?php echo e(__('expense.title')); ?> </span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($d_expense); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"> <?php echo e(__('dashboard.balance')); ?></span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($d_income - $d_expense); ?></span>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-4">
                        <ul class="list-group mt-2">
                            <li class="list-group-item profile-list-group-item text-center">
                                <span class=" font-weight-bold"> <?php echo e(__('dashboard.merchant')); ?>

                                    <?php echo e(__('dashboard.statements')); ?> </span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"> <?php echo e(__('income.title')); ?> </span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($m_income); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"><?php echo e(__('expense.title')); ?> </span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($m_expense); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"> <?php echo e(__('dashboard.balance')); ?></span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($m_income - $m_expense); ?></span>
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-4">
                        <ul class="list-group mt-2 ">
                            <li class="list-group-item profile-list-group-item text-center">
                                <span class="font-weight-bold"><?php echo e(__('hub.title')); ?>

                                    <?php echo e(__('dashboard.statements')); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"> <?php echo e(__('income.title')); ?> </span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($h_income); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"><?php echo e(__('expense.title')); ?> </span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($h_expense); ?></span>
                            </li>
                            <li class="list-group-item profile-list-group-item">
                                <span class="float-left font-weight-bold"> <?php echo e(__('dashboard.balance')); ?></span>
                                <span class="float-right"> <?php echo e(settings()->currency); ?><?php echo e($h_income - $h_expense); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>

            <div class="row">
                <?php if(hasPermission('income_expense_charts') == true): ?>
                    <div class="col-xl-6 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="apexcharts" id="apexincomeexpense"></div>
                            </div>
                            <div class="card-footer">
                                <p class="display-7 font-weight-bold">
                                    <span class="legend-text text-primary d-inline-block"><?php echo e(settings()->currency); ?>

                                        <?php echo e($data['income']); ?></span>
                                    <span class="text-secondary float-right"><?php echo e(settings()->currency); ?>

                                        <?php echo e($data['expense']); ?></span>
                                </p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if(hasPermission('courier_revenue_charts') == true): ?>
                    <div class="col-xl-6 col-lg-12 col-md-12 col-sm-12 col-12">
                        <div class="card">
                            <div class="card-body courier-pie-charts">
                                <div class="apexcharts" id="apexpiecourierrevenue"></div>
                            </div>
                            <div class="card-footer">
                                <p class="display-7 font-weight-bold">
                                    <span class="text-primary d-inline-block"><?php echo e(settings()->currency); ?>

                                        <?php echo e($data['courier_income']); ?></span>
                                    <span class="text-secondary float-right"><?php echo e(settings()->currency); ?>

                                        <?php echo e($data['courier_expense']); ?></span>
                                </p>
                            </div>
                        </div>
                    </div>
                    
                <?php endif; ?>
            </div>
            <!-- recent parcel  -->

            <?php if(hasPermission('calendar_read') == true): ?>
                <div class="row mb-5">
                    <div class=" col-12 ">
                        <div class="card mb-0 mt-4">
                            <div class="card-body ">
                                <div style="overflow:hidden;">
                                    <div class="form-group">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div id="datetimepicker12"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>


        </div>
    </div>

    </div>
    </div>
    <!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<!-- css  -->
<?php $__env->startPush('styles'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(static_asset('backend/vendor/calender/main.css')); ?>" />
    <!-- Tempus Dominus Styles -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/eonasdan-bootstrap-datetimepicker/4.17.49/css/bootstrap-datetimepicker.min.css"
        integrity="sha512-ipfmbgqfdejR27dWn02UftaAzUfxJ3HR4BDQYuITYSj6ZQfGT1NulP4BOery3w/dT2PYAe3bG5Zm/owm7MuFhA==" crossorigin="anonymous"
        referrerpolicy="no-referrer" />
    <style>
        .notification .nav-link.nav-icons {
            margin-top: 0px !important;
        }

        .admin-panel.notification .nav-link.nav-icons .indicator {
            top: 15px !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<!-- js  -->
<?php $__env->startPush('scripts'); ?>
    <script type="text/javascript" src="<?php echo e(static_asset('backend/js/charts/apexcharts.js')); ?>"></script>
    <?php echo $__env->make('backend.dashboard-charts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('backend.calender-js', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script type="text/javascript"
        src="<?php echo e(static_asset('backend/js/date-range-picker/dashboard-date-range-picker-custom.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!-- datetime -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"
        crossorigin="anonymous"></script>


    <script type="text/javascript">
        $('#datetimepicker12').datetimepicker({
            inline: true,
            sideBySide: true
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/dashboard.blade.php ENDPATH**/ ?>