<div class="table-responsive">
    <table class="table" style="width:100%">
        <thead>
            <tr>
                <th><?php echo e(__('levels.id')); ?></th>
                <th><?php echo e(__('parcel.merchant')); ?></th>
                <th><?php echo e(__('levels.date')); ?></th>
                <th><?php echo e(__('parcel.transaction_id')); ?></th>
                <th><?php echo e(__('parcel.payment_method')); ?></th>
                <th><?php echo e(__('parcel.amount')); ?></th>
                <th><?php echo e(__('parcel.status')); ?></th>
                <th><?php echo e(__('levels.actions')); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
                $i = 0;
            ?>
            <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e(++$i); ?></td>
                    <td class="merchantpayment">

                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <img src="<?php echo e(@$wallet->user->image); ?>" alt="user" class="rounded" width="40"
                                    height="40">
                            </div>
                            <div class="col-md-8">
                                <p><?php echo e(@$wallet->merchant->business_name); ?></p>
                                <p><?php echo e(@$wallet->merchant->user->mobile); ?></p>
                                <p><?php echo e(@$wallet->merchant->address); ?></p>
                            </div>
                        </div>

                    </td>
                    <td>
                        <?php echo e(dateFormat($wallet->created_at)); ?>

                    </td>
                    <td><?php echo e(@$wallet->transaction_id); ?></td>
                    <td><?php echo e(__('WalletPaymentMethod.' . $wallet->payment_method)); ?></td>
                    <td>
                        <?php if($wallet->type == App\Enums\Wallet\WalletType::INCOME): ?>
                            <span class="text-success font-weight-bold"> +
                                <?php echo e(settings()->currency); ?><?php echo e(@$wallet->amount); ?></span>
                        <?php elseif($wallet->type == App\Enums\Wallet\WalletType::EXPENSE): ?>
                            <span class="text-danger font-weight-bold"> -
                                <?php echo e(settings()->currency); ?><?php echo e(@$wallet->amount); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if(App\Enums\Wallet\WalletType::EXPENSE != $wallet->type): ?>
                            <?php echo @$wallet->my_status; ?>

                        <?php endif; ?>
                    </td>

                    <?php if(hasPermission('wallet_request_approve') ||
                            hasPermission('wallet_request_reject') ||
                            hasPermission('wallet_request_delete')): ?>
                        <td class="wallet-action">
                            <div class="row">
                                <button tabindex="-1" data-toggle="dropdown" type="button"
                                    class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span
                                        class="sr-only">Toggle Dropdown</span></button>
                                <div class="dropdown-menu">
                                    <?php if(App\Enums\Wallet\WalletType::EXPENSE != $wallet->type): ?>
                                        <?php if(@$wallet->status == \App\Enums\Wallet\WalletStatus::PENDING): ?>
                                            <?php if(hasPermission('wallet_request_approve')): ?>
                                                <form id="delete"
                                                    data-title="<?php echo e(__('parcel.are_you_approve_this_request')); ?>"
                                                    action="<?php echo e(route('wallet.request.approve', $wallet->id)); ?>"
                                                    method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('put'); ?>
                                                    <button type="submit" title="Approve" class="dropdown-item"><i
                                                            class="fa fa-check  me-2 "></i>
                                                        <?php echo e(__('parcel.approve')); ?></button>
                                                </form>
                                            <?php endif; ?>
                                            <?php if(hasPermission('wallet_request_reject')): ?>
                                                <form id="delete"
                                                    action="<?php echo e(route('wallet.request.reject', $wallet->id)); ?>"
                                                    data-title="<?php echo e(__('parcel.are_you_reject_this_request')); ?>"
                                                    method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('put'); ?>
                                                    <button type="submit" class="dropdown-item" title="Reject"><i
                                                            class="fa fa-close me-2 "></i>
                                                        <?php echo e(__('parcel.reject')); ?></button>
                                                </form>
                                            <?php endif; ?>
                                        <?php endif; ?>

                                        <?php if(hasPermission('wallet_request_delete')): ?>
                                            <form id="delete" data-title="<?php echo e(__('parcel.delete_wallet')); ?>"
                                                action="<?php echo e(route('wallet.request.delete', $wallet->id)); ?>"
                                                method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('delete'); ?>
                                                <button type="submit" title="Delete" class="dropdown-item"><i
                                                        class="fa fa-trash me-2"></i><?php echo e(__('levels.delete')); ?></button>
                                            </form>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                        </td>
                    <?php endif; ?>

                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr>
        </tbody>
    </table>
</div>
<div class="px-3 d-flex flex-row-reverse align-items-center">
    <span><?php echo e($wallets->links()); ?></span>
    <p class="p-2 small">
        <?php echo __('Showing'); ?>

        <span class="font-medium"><?php echo e($wallets->firstItem()); ?></span>
        <?php echo __('to'); ?>

        <span class="font-medium"><?php echo e($wallets->lastItem()); ?></span>
        <?php echo __('of'); ?>

        <span class="font-medium"><?php echo e($wallets->total()); ?></span>
        <?php echo __('results'); ?>

    </p>
</div>
<?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/wallet_request/all_transaction.blade.php ENDPATH**/ ?>