<?php $__env->startSection('title'); ?>
    <?php echo e(__('hub_payment_request.title')); ?> <?php echo e(__('levels.list')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('maincontent'); ?>
<!-- wrapper  -->
<div class="container-fluid  dashboard-content">
    <!-- pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="page-header">
                <div class="page-breadcrumb">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.index')); ?>" class="breadcrumb-link"><?php echo e(__('levels.dashboard')); ?></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('hub-panel.payment-request.index')); ?>" class="breadcrumb-link"><?php echo e(__('hub_payment_request.title')); ?></a></li>
                            <li class="breadcrumb-item"><a href="" class="breadcrumb-link active"><?php echo e(__('levels.list')); ?></a></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!-- end pageheader -->
    <div class="row">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
            <div class="card">
                <div class="row pl-4 pr-4 pt-4">
                    <div class="col-6">
                        <p class="h3"><?php echo e(__('hub_payment_request.title')); ?> <?php echo e(__('levels.list')); ?></p>
                    </div>
                    <?php if( hasPermission('hub_payment_request_create') == true ): ?>
                    <div class="col-6">
                        <a href="<?php echo e(route('hub-panel.payment-request.create')); ?>" class="btn btn-primary btn-sm float-right" data-toggle="tooltip" data-placement="top" title="<?php echo e(__('levels.add')); ?>"><i class="fa fa-plus"></i></a>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table   " style="width:100%">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('levels.id')); ?></th>
                                    <th><?php echo e(__('hub_payment.transaction_id')); ?></th>
                                    <th><?php echo e(__('hub_payment.description')); ?></th>
                                    <th><?php echo e(__('hub_payment_request.request_date')); ?></th>
                                    <th><?php echo e(__('levels.status')); ?></th>
                                    <th><?php echo e(__('hub_payment.amount')); ?></th>
                                    <?php if(  hasPermission('hub_payment_request_update') == true || hasPermission('hub_payment_request_delete') == true ): ?>
                                        <th><?php echo e(__('levels.actions')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=1; ?>
                                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($i++); ?></td>
                                    <td><?php echo e($payment->transaction_id); ?></td>
                                    <td><?php echo e($payment->description); ?></td>
                                    <td>
                                         <?php echo e(date('d M Y H:i:s a',strtotime($payment->created_at))); ?>

                                    </td>
                                    <td>

                                        <?php if($payment->status == \App\Enums\ApprovalStatus::REJECT): ?>
                                        <span class="badge badge-pill badge-danger"><?php echo e(trans('approvalstatus.'.\App\Enums\ApprovalStatus::REJECT)); ?></span>
                                        <?php elseif($payment->status == \App\Enums\ApprovalStatus::PENDING): ?>
                                        <span class="badge badge-pill badge-warning"><?php echo e(trans('approvalstatus.'.\App\Enums\ApprovalStatus::PENDING)); ?></span>
                                        <?php elseif($payment->status == \App\Enums\ApprovalStatus::PROCESSED): ?>
                                        <span class="badge badge-pill badge-success"><?php echo e(trans('approvalstatus.'.\App\Enums\ApprovalStatus::PROCESSED)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(settings()->currency); ?> <?php echo e($payment->amount); ?></td>
                                    <?php if(  hasPermission('hub_payment_request_update') == true || hasPermission('hub_payment_request_delete') == true ): ?>
                                        <td>
                                            <?php if($payment->status == \App\Enums\ApprovalStatus::PENDING): ?>
                                                <div class="row">
                                                    <button tabindex="-1" data-toggle="dropdown" type="button" class="btn btn-primary dropdown-toggle dropdown-toggle-split"><span class="sr-only">Toggle Dropdown</span></button>
                                                    <div class="dropdown-menu">
                                                        <?php if( hasPermission('hub_payment_request_delete') == true ): ?>
                                                            <form id="delete"  action="<?php echo e(route('hub-panel.payment-request.delete',$payment->id)); ?>" method="POST" data-title="<?php echo e(__('delete.hub_payment_request')); ?>">
                                                                <?php echo method_field('DELETE'); ?>
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" name="" value="Payment" id="deleteTitle">
                                                                <button type="submit" class="dropdown-item"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo e(__('levels.delete')); ?></button>
                                                            </form>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                            ...
                                            <?php endif; ?>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="px-3 d-flex flex-row-reverse align-items-center">
                            <span><?php echo e($payments->links()); ?></span>
                            <p class="p-2 small">
                                <?php echo __('Showing'); ?>

                                <span class="font-medium"><?php echo e($payments->firstItem()); ?></span>
                                <?php echo __('to'); ?>

                                <span class="font-medium"><?php echo e($payments->lastItem()); ?></span>
                                <?php echo __('of'); ?>

                                <span class="font-medium"><?php echo e($payments->total()); ?></span>
                                <?php echo __('results'); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- end wrapper  -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.partials.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Hamza\Downloads\Web scurce code\Web\resources\views/backend/hub_panel/hub_payment_request/index.blade.php ENDPATH**/ ?>