<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\APIhub;

class GoogleCloudApihubV1DeploymentMetadata extends \Google\Model
{
  protected $deploymentType = GoogleCloudApihubV1Deployment::class;
  protected $deploymentDataType = '';
  /**
   * Optional. Timestamp indicating when the deployment was created at the
   * source.
   *
   * @var string
   */
  public $originalCreateTime;
  /**
   * Optional. The unique identifier of the deployment in the system where it
   * was originally created.
   *
   * @var string
   */
  public $originalId;
  /**
   * Required. Timestamp indicating when the deployment was last updated at the
   * source.
   *
   * @var string
   */
  public $originalUpdateTime;

  /**
   * Required. The deployment resource to be pushed to Hub's collect layer. The
   * ID of the deployment will be generated by Hub.
   *
   * @param GoogleCloudApihubV1Deployment $deployment
   */
  public function setDeployment(GoogleCloudApihubV1Deployment $deployment)
  {
    $this->deployment = $deployment;
  }
  /**
   * @return GoogleCloudApihubV1Deployment
   */
  public function getDeployment()
  {
    return $this->deployment;
  }
  /**
   * Optional. Timestamp indicating when the deployment was created at the
   * source.
   *
   * @param string $originalCreateTime
   */
  public function setOriginalCreateTime($originalCreateTime)
  {
    $this->originalCreateTime = $originalCreateTime;
  }
  /**
   * @return string
   */
  public function getOriginalCreateTime()
  {
    return $this->originalCreateTime;
  }
  /**
   * Optional. The unique identifier of the deployment in the system where it
   * was originally created.
   *
   * @param string $originalId
   */
  public function setOriginalId($originalId)
  {
    $this->originalId = $originalId;
  }
  /**
   * @return string
   */
  public function getOriginalId()
  {
    return $this->originalId;
  }
  /**
   * Required. Timestamp indicating when the deployment was last updated at the
   * source.
   *
   * @param string $originalUpdateTime
   */
  public function setOriginalUpdateTime($originalUpdateTime)
  {
    $this->originalUpdateTime = $originalUpdateTime;
  }
  /**
   * @return string
   */
  public function getOriginalUpdateTime()
  {
    return $this->originalUpdateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApihubV1DeploymentMetadata::class, 'Google_Service_APIhub_GoogleCloudApihubV1DeploymentMetadata');
