<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class SubmitProvisioningConfigRequest extends \Google\Model
{
  /**
   * Optional. Email provided to send a confirmation with provisioning config
   * to.
   *
   * @var string
   */
  public $email;
  protected $provisioningConfigType = ProvisioningConfig::class;
  protected $provisioningConfigDataType = '';

  /**
   * Optional. Email provided to send a confirmation with provisioning config
   * to.
   *
   * @param string $email
   */
  public function setEmail($email)
  {
    $this->email = $email;
  }
  /**
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }
  /**
   * Required. The ProvisioningConfig to create.
   *
   * @param ProvisioningConfig $provisioningConfig
   */
  public function setProvisioningConfig(ProvisioningConfig $provisioningConfig)
  {
    $this->provisioningConfig = $provisioningConfig;
  }
  /**
   * @return ProvisioningConfig
   */
  public function getProvisioningConfig()
  {
    return $this->provisioningConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SubmitProvisioningConfigRequest::class, 'Google_Service_Baremetalsolution_SubmitProvisioningConfigRequest');
