<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CertificateManager;

class ManagedIdentityCertificate extends \Google\Model
{
  /**
   * State is unspecified.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * Certificate Manager attempts to provision or renew the certificate. If the
   * process takes longer than expected, consult the `provisioning_issue` field.
   */
  public const STATE_PROVISIONING = 'PROVISIONING';
  /**
   * Multiple certificate provisioning attempts failed and Certificate Manager
   * gave up. To try again, delete and create a new managed Certificate
   * resource. For details see the `provisioning_issue` field.
   */
  public const STATE_FAILED = 'FAILED';
  /**
   * The certificate management is working, and a certificate has been
   * provisioned.
   */
  public const STATE_ACTIVE = 'ACTIVE';
  /**
   * Required. Immutable. SPIFFE ID of the Managed Identity used for this
   * certificate.
   *
   * @var string
   */
  public $identity;
  protected $provisioningIssueType = ProvisioningIssue::class;
  protected $provisioningIssueDataType = '';
  /**
   * Output only. State of the managed certificate resource.
   *
   * @var string
   */
  public $state;

  /**
   * Required. Immutable. SPIFFE ID of the Managed Identity used for this
   * certificate.
   *
   * @param string $identity
   */
  public function setIdentity($identity)
  {
    $this->identity = $identity;
  }
  /**
   * @return string
   */
  public function getIdentity()
  {
    return $this->identity;
  }
  /**
   * Output only. Information about issues with provisioning a managed
   * certificate.
   *
   * @param ProvisioningIssue $provisioningIssue
   */
  public function setProvisioningIssue(ProvisioningIssue $provisioningIssue)
  {
    $this->provisioningIssue = $provisioningIssue;
  }
  /**
   * @return ProvisioningIssue
   */
  public function getProvisioningIssue()
  {
    return $this->provisioningIssue;
  }
  /**
   * Output only. State of the managed certificate resource.
   *
   * Accepted values: STATE_UNSPECIFIED, PROVISIONING, FAILED, ACTIVE
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ManagedIdentityCertificate::class, 'Google_Service_CertificateManager_ManagedIdentityCertificate');
