<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class FutureResourcesRecommendation extends \Google\Model
{
  /**
   * A Future Reservation is recommended.
   */
  public const RECOMMENDATION_TYPE_FUTURE_RESERVATION = 'FUTURE_RESERVATION';
  /**
   * Default value, unused.
   */
  public const RECOMMENDATION_TYPE_RECOMMENDATION_TYPE_UNSPECIFIED = 'RECOMMENDATION_TYPE_UNSPECIFIED';
  /**
   * @var string
   */
  public $endTime;
  /**
   * The advised location for resource usage. When a zone, in format 'zones/'.
   * If not set, it means that no location is recommended - see other_locations
   * for details.
   *
   * @var string
   */
  public $location;
  protected $otherLocationsType = FutureResourcesRecommendationOtherLocation::class;
  protected $otherLocationsDataType = 'map';
  /**
   * Unique id of the recommendation, a UUID string generated by the API.
   *
   * @var string
   */
  public $recommendationId;
  /**
   * Type of recommendation. Currently only FUTURE_RESERVATION is supported.
   *
   * @var string
   */
  public $recommendationType;
  /**
   * @var string
   */
  public $startTime;

  /**
   * @param string $endTime
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * The advised location for resource usage. When a zone, in format 'zones/'.
   * If not set, it means that no location is recommended - see other_locations
   * for details.
   *
   * @param string $location
   */
  public function setLocation($location)
  {
    $this->location = $location;
  }
  /**
   * @return string
   */
  public function getLocation()
  {
    return $this->location;
  }
  /**
   * List of locations in the request scope that were not recommended. Keys of
   * the map are zones, in format 'zones/'. The values are status information
   * indicating the recommendation status.
   *
   * @param FutureResourcesRecommendationOtherLocation[] $otherLocations
   */
  public function setOtherLocations($otherLocations)
  {
    $this->otherLocations = $otherLocations;
  }
  /**
   * @return FutureResourcesRecommendationOtherLocation[]
   */
  public function getOtherLocations()
  {
    return $this->otherLocations;
  }
  /**
   * Unique id of the recommendation, a UUID string generated by the API.
   *
   * @param string $recommendationId
   */
  public function setRecommendationId($recommendationId)
  {
    $this->recommendationId = $recommendationId;
  }
  /**
   * @return string
   */
  public function getRecommendationId()
  {
    return $this->recommendationId;
  }
  /**
   * Type of recommendation. Currently only FUTURE_RESERVATION is supported.
   *
   * Accepted values: FUTURE_RESERVATION, RECOMMENDATION_TYPE_UNSPECIFIED
   *
   * @param self::RECOMMENDATION_TYPE_* $recommendationType
   */
  public function setRecommendationType($recommendationType)
  {
    $this->recommendationType = $recommendationType;
  }
  /**
   * @return self::RECOMMENDATION_TYPE_*
   */
  public function getRecommendationType()
  {
    return $this->recommendationType;
  }
  /**
   * @param string $startTime
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FutureResourcesRecommendation::class, 'Google_Service_Compute_FutureResourcesRecommendation');
