<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InstanceSettings extends \Google\Model
{
  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash
   * of the instance settings resource's contents and used for optimistic
   * locking. The fingerprint is initially generated by Compute Engine and
   * changes after every request to modify or update the instance settings
   * resource. You must always provide an up-to-date fingerprint hash in order
   * to update or change the resource, otherwise the request will fail with
   * error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve the
   * resource.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * Output only. [Output Only] Type of the resource.
   * Alwayscompute#instance_settings for instance settings.
   *
   * @var string
   */
  public $kind;
  protected $metadataType = InstanceSettingsMetadata::class;
  protected $metadataDataType = '';
  /**
   * Output only. [Output Only] URL of the zone where the resource resides You
   * must specify this field as part of the HTTP request URL. It is not settable
   * as a field in the request body.
   *
   * @var string
   */
  public $zone;

  /**
   * Specifies a fingerprint for instance settings, which is essentially a hash
   * of the instance settings resource's contents and used for optimistic
   * locking. The fingerprint is initially generated by Compute Engine and
   * changes after every request to modify or update the instance settings
   * resource. You must always provide an up-to-date fingerprint hash in order
   * to update or change the resource, otherwise the request will fail with
   * error 412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve the
   * resource.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * Output only. [Output Only] Type of the resource.
   * Alwayscompute#instance_settings for instance settings.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The metadata key/value pairs assigned to all the instances in the
   * corresponding scope.
   *
   * @param InstanceSettingsMetadata $metadata
   */
  public function setMetadata(InstanceSettingsMetadata $metadata)
  {
    $this->metadata = $metadata;
  }
  /**
   * @return InstanceSettingsMetadata
   */
  public function getMetadata()
  {
    return $this->metadata;
  }
  /**
   * Output only. [Output Only] URL of the zone where the resource resides You
   * must specify this field as part of the HTTP request URL. It is not settable
   * as a field in the request body.
   *
   * @param string $zone
   */
  public function setZone($zone)
  {
    $this->zone = $zone;
  }
  /**
   * @return string
   */
  public function getZone()
  {
    return $this->zone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InstanceSettings::class, 'Google_Service_Compute_InstanceSettings');
