<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\IdentityToolkit;

class IdentitytoolkitRelyingpartyEmailLinkSigninRequest extends \Google\Model
{
  /**
   * The email address of the user.
   *
   * @var string
   */
  public $email;
  /**
   * Token for linking flow.
   *
   * @var string
   */
  public $idToken;
  /**
   * The confirmation code.
   *
   * @var string
   */
  public $oobCode;

  /**
   * The email address of the user.
   *
   * @param string $email
   */
  public function setEmail($email)
  {
    $this->email = $email;
  }
  /**
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }
  /**
   * Token for linking flow.
   *
   * @param string $idToken
   */
  public function setIdToken($idToken)
  {
    $this->idToken = $idToken;
  }
  /**
   * @return string
   */
  public function getIdToken()
  {
    return $this->idToken;
  }
  /**
   * The confirmation code.
   *
   * @param string $oobCode
   */
  public function setOobCode($oobCode)
  {
    $this->oobCode = $oobCode;
  }
  /**
   * @return string
   */
  public function getOobCode()
  {
    return $this->oobCode;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(IdentitytoolkitRelyingpartyEmailLinkSigninRequest::class, 'Google_Service_IdentityToolkit_IdentitytoolkitRelyingpartyEmailLinkSigninRequest');
