<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Recommender;

class GoogleCloudRecommenderV1ListInsightsResponse extends \Google\Collection
{
  protected $collection_key = 'insights';
  protected $insightsType = GoogleCloudRecommenderV1Insight::class;
  protected $insightsDataType = 'array';
  /**
   * A token that can be used to request the next page of results. This field is
   * empty if there are no additional results.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * The set of insights for the `parent` resource.
   *
   * @param GoogleCloudRecommenderV1Insight[] $insights
   */
  public function setInsights($insights)
  {
    $this->insights = $insights;
  }
  /**
   * @return GoogleCloudRecommenderV1Insight[]
   */
  public function getInsights()
  {
    return $this->insights;
  }
  /**
   * A token that can be used to request the next page of results. This field is
   * empty if there are no additional results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRecommenderV1ListInsightsResponse::class, 'Google_Service_Recommender_GoogleCloudRecommenderV1ListInsightsResponse');
