<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Spanner;

class PartitionEndRecord extends \Google\Model
{
  /**
   * End timestamp at which the change stream partition is terminated. All
   * changes generated by this partition will have timestamps <= end_timestamp.
   * DataChangeRecord.commit_timestamps, PartitionStartRecord.start_timestamps,
   * PartitionEventRecord.commit_timestamps, and
   * PartitionEndRecord.end_timestamps can have the same value in the same
   * partition. PartitionEndRecord is the last record returned for a partition.
   *
   * @var string
   */
  public $endTimestamp;
  /**
   * Unique partition identifier describing the terminated change stream
   * partition. partition_token is equal to the partition token of the change
   * stream partition currently queried to return this PartitionEndRecord.
   *
   * @var string
   */
  public $partitionToken;
  /**
   * Record sequence numbers are unique and monotonically increasing (but not
   * necessarily contiguous) for a specific timestamp across record types in the
   * same partition. To guarantee ordered processing, the reader should process
   * records (of potentially different types) in record_sequence order for a
   * specific timestamp in the same partition.
   *
   * @var string
   */
  public $recordSequence;

  /**
   * End timestamp at which the change stream partition is terminated. All
   * changes generated by this partition will have timestamps <= end_timestamp.
   * DataChangeRecord.commit_timestamps, PartitionStartRecord.start_timestamps,
   * PartitionEventRecord.commit_timestamps, and
   * PartitionEndRecord.end_timestamps can have the same value in the same
   * partition. PartitionEndRecord is the last record returned for a partition.
   *
   * @param string $endTimestamp
   */
  public function setEndTimestamp($endTimestamp)
  {
    $this->endTimestamp = $endTimestamp;
  }
  /**
   * @return string
   */
  public function getEndTimestamp()
  {
    return $this->endTimestamp;
  }
  /**
   * Unique partition identifier describing the terminated change stream
   * partition. partition_token is equal to the partition token of the change
   * stream partition currently queried to return this PartitionEndRecord.
   *
   * @param string $partitionToken
   */
  public function setPartitionToken($partitionToken)
  {
    $this->partitionToken = $partitionToken;
  }
  /**
   * @return string
   */
  public function getPartitionToken()
  {
    return $this->partitionToken;
  }
  /**
   * Record sequence numbers are unique and monotonically increasing (but not
   * necessarily contiguous) for a specific timestamp across record types in the
   * same partition. To guarantee ordered processing, the reader should process
   * records (of potentially different types) in record_sequence order for a
   * specific timestamp in the same partition.
   *
   * @param string $recordSequence
   */
  public function setRecordSequence($recordSequence)
  {
    $this->recordSequence = $recordSequence;
  }
  /**
   * @return string
   */
  public function getRecordSequence()
  {
    return $this->recordSequence;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PartitionEndRecord::class, 'Google_Service_Spanner_PartitionEndRecord');
