<?php

/*
 * This file is part of Psy Shell.
 *
 * (c) 2012-2026 Justin Hileman
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Psy\Test\Command;

use Symfony\Component\Console\Output\BufferedOutput;

/**
 * A BufferedOutput that supports the page() and paging methods used by ShellOutput.
 */
class TestOutput extends BufferedOutput
{
    public function page($messages, int $type = 0)
    {
        if (\is_string($messages)) {
            // Split on newlines to avoid O(n^2) performance in Symfony's OutputFormatter
            // when processing large strings with many style tags.
            $messages = \explode("\n", $messages);
        }

        if (\is_callable($messages)) {
            $messages($this);
        } else {
            $this->write($messages, true, $type);
        }
    }

    public function startPaging()
    {
        // no-op for testing
    }

    public function stopPaging()
    {
        // no-op for testing
    }
}
