<?php

declare(strict_types=1);

namespace VonageTest\Account;

use VonageTest\VonageTestCase;
use Vonage\Account\SmsPrice;

class SmsPriceTest extends VonageTestCase
{
    /**
     * @dataProvider smsPriceProvider
     *
     * @param $smsPrice
     */
    public function testFromArray($smsPrice): void
    {
        $this->assertEquals("US", $smsPrice->getCountryCode());
        $this->assertEquals("United States", $smsPrice->getCountryName());
        $this->assertEquals("1", $smsPrice->getDialingPrefix());
        $this->assertEquals("0.00512", $smsPrice->getDefaultPrice());
    }

    /**
     * @dataProvider smsPriceProvider
     *
     * @param $smsPrice
     */
    public function testGetters($smsPrice): void
    {
        $this->assertEquals("US", $smsPrice->getCountryCode());
        $this->assertEquals("United States", $smsPrice->getCountryName());
        $this->assertEquals("United States", $smsPrice->getCountryDisplayName());
        $this->assertEquals("1", $smsPrice->getDialingPrefix());
        $this->assertEquals("0.00512", $smsPrice->getDefaultPrice());
    }

    /**
     * @dataProvider smsPriceProvider
     *
     * @param $smsPrice
     */
    public function testUsesCustomPriceForKnownNetwork($smsPrice): void
    {
        $this->assertEquals("0.123", $smsPrice->getPriceForNetwork('21039'));
    }

    /**
     * @dataProvider smsPriceProvider
     *
     * @param $smsPrice
     */
    public function testUsesDefaultPriceForUnknownNetwork($smsPrice): void
    {
        $this->assertEquals("0.00512", $smsPrice->getPriceForNetwork('007'));
    }

    public function smsPriceProvider(): array
    {
        $r = [];

        $smsPrice = new SmsPrice();
        $smsPrice->fromArray([
            'dialing_prefix' => 1,
            'default_price' => '0.00512',
            'currency' => 'EUR',
            'country_code' => 'US',
            'country_name' => 'United States',
            'country_display_name' => 'United States',
            'prefix' => 1,
            'networks' => [
                [
                    'currency' => 'EUR',
                    'networkCode' => '21039',
                    'networkName' => 'Demo Network',
                    'price' => '0.123'
                ]
            ]
        ]);
        $r['jsonUnserialize'] = [$smsPrice];

        return $r;
    }
}
