<?php

declare(strict_types=1);

namespace VonageTest\Client\Credentials;

use VonageTest\VonageTestCase;
use Vonage\Client\Credentials\Basic;
use Vonage\Client\Credentials\Container;
use Vonage\Client\Credentials\Keypair;
use Vonage\Client\Credentials\SignatureSecret;

class ContainerTest extends VonageTestCase
{
    protected array $types = [
        Basic::class,
        SignatureSecret::class,
        Keypair::class
    ];

    protected Basic $basic;
    protected SignatureSecret $secret;
    protected Keypair $keypair;

    public function setUp(): void
    {
        $this->basic = new Basic('key', 'secret');
        $this->secret = new SignatureSecret('key', 'secret');
        $this->keypair = new Keypair('key', 'app');
    }

    /**
     * @dataProvider credentials
     *
     * @param $credential
     * @param $type
     */
    public function testBasic($credential, $type): void
    {
        $container = new Container($credential);

        $this->assertSame($credential, $container->get($type));

        foreach ($this->types as $class) {
            if ($type === $class) {
                $this->assertTrue($container->has($class));
            } else {
                $this->assertFalse($container->has($class));
            }
        }
    }

    /**
     * @dataProvider credentials
     *
     * @param $credential
     */
    public function testOnlyOneType($credential): void
    {
        $this->expectException('RuntimeException');

        new Container($credential, clone $credential);
    }

    public function testMultiple(): void
    {
        $container = new Container($this->basic, $this->secret, $this->keypair);

        foreach ($this->types as $class) {
            $this->assertTrue($container->has($class));
        }
    }

    /**
     * @return array[]
     */
    public function credentials(): array
    {
        return [
            [new Basic('key', 'secret'), Basic::class],
            [new SignatureSecret('key', 'secret'), SignatureSecret::class],
            [new Keypair('key', 'app'), Keypair::class]
        ];
    }
}
