<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1AsyncApiDocumentation extends \Google\Model
{
  protected $specType = GoogleCloudApigeeV1DocumentationFile::class;
  protected $specDataType = '';

  /**
   * Required. The documentation file contents for the AsyncAPI Specification.
   * JSON and YAML file formats are supported.
   *
   * @param GoogleCloudApigeeV1DocumentationFile $spec
   */
  public function setSpec(GoogleCloudApigeeV1DocumentationFile $spec)
  {
    $this->spec = $spec;
  }
  /**
   * @return GoogleCloudApigeeV1DocumentationFile
   */
  public function getSpec()
  {
    return $this->spec;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1AsyncApiDocumentation::class, 'Google_Service_Apigee_GoogleCloudApigeeV1AsyncApiDocumentation');
