<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1DataCollectorConfig extends \Google\Model
{
  /**
   * For future compatibility.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * For integer values.
   */
  public const TYPE_INTEGER = 'INTEGER';
  /**
   * For float values.
   */
  public const TYPE_FLOAT = 'FLOAT';
  /**
   * For string values.
   */
  public const TYPE_STRING = 'STRING';
  /**
   * For boolean values.
   */
  public const TYPE_BOOLEAN = 'BOOLEAN';
  /**
   * For datetime values.
   */
  public const TYPE_DATETIME = 'DATETIME';
  /**
   * Name of the data collector in the following format:
   * `organizations/{org}/datacollectors/{datacollector}`
   *
   * @var string
   */
  public $name;
  /**
   * Data type accepted by the data collector.
   *
   * @var string
   */
  public $type;

  /**
   * Name of the data collector in the following format:
   * `organizations/{org}/datacollectors/{datacollector}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Data type accepted by the data collector.
   *
   * Accepted values: TYPE_UNSPECIFIED, INTEGER, FLOAT, STRING, BOOLEAN,
   * DATETIME
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1DataCollectorConfig::class, 'Google_Service_Apigee_GoogleCloudApigeeV1DataCollectorConfig');
