<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput extends \Google\Collection
{
  /**
   * The type is unspecified.
   */
  public const TEXT_TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * The text is part of LLM reasoning.
   */
  public const TEXT_TYPE_THOUGHT = 'THOUGHT';
  /**
   * The text is the final answer from LLM.
   */
  public const TEXT_TYPE_FINAL_RESPONSE = 'FINAL_RESPONSE';
  /**
   * The text is an informational message about the agent's progress, such as a
   * tool being invoked. This is distinct from the agent's internal thought
   * process (`THOUGHT`) and the final answer to the user (`FINAL_RESPONSE`).
   * These messages provide insight into the agent's actions.
   */
  public const TEXT_TYPE_PROGRESS = 'PROGRESS';
  protected $collection_key = 'text';
  /**
   * The text output from the LLM.
   *
   * @var string[]
   */
  public $text;
  /**
   * The type of text output.
   *
   * @var string
   */
  public $textType;

  /**
   * The text output from the LLM.
   *
   * @param string[] $text
   */
  public function setText($text)
  {
    $this->text = $text;
  }
  /**
   * @return string[]
   */
  public function getText()
  {
    return $this->text;
  }
  /**
   * The type of text output.
   *
   * Accepted values: TYPE_UNSPECIFIED, THOUGHT, FINAL_RESPONSE, PROGRESS
   *
   * @param self::TEXT_TYPE_* $textType
   */
  public function setTextType($textType)
  {
    $this->textType = $textType;
  }
  /**
   * @return self::TEXT_TYPE_*
   */
  public function getTextType()
  {
    return $this->textType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1mainGenerativeInsightsResponseGenerativeResponseTextOutput');
