<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CustomerEngagementSuite;

class GenerateChatTokenRequest extends \Google\Model
{
  /**
   * Required. The deployment of the app to use for the session. Format:
   * projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
   *
   * @var string
   */
  public $deployment;
  /**
   * Optional. The reCAPTCHA token generated by the client-side chat widget.
   *
   * @var string
   */
  public $recaptchaToken;

  /**
   * Required. The deployment of the app to use for the session. Format:
   * projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
   *
   * @param string $deployment
   */
  public function setDeployment($deployment)
  {
    $this->deployment = $deployment;
  }
  /**
   * @return string
   */
  public function getDeployment()
  {
    return $this->deployment;
  }
  /**
   * Optional. The reCAPTCHA token generated by the client-side chat widget.
   *
   * @param string $recaptchaToken
   */
  public function setRecaptchaToken($recaptchaToken)
  {
    $this->recaptchaToken = $recaptchaToken;
  }
  /**
   * @return string
   */
  public function getRecaptchaToken()
  {
    return $this->recaptchaToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GenerateChatTokenRequest::class, 'Google_Service_CustomerEngagementSuite_GenerateChatTokenRequest');
