<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CustomerEngagementSuite;

class Tool extends \Google\Model
{
  /**
   * The execution type is unspecified. Defaults to `SYNCHRONOUS` if
   * unspecified.
   */
  public const EXECUTION_TYPE_EXECUTION_TYPE_UNSPECIFIED = 'EXECUTION_TYPE_UNSPECIFIED';
  /**
   * The tool is executed synchronously. The session is blocked until the tool
   * returns.
   */
  public const EXECUTION_TYPE_SYNCHRONOUS = 'SYNCHRONOUS';
  /**
   * The tool is executed asynchronously. The session will continue while the
   * tool is executing.
   */
  public const EXECUTION_TYPE_ASYNCHRONOUS = 'ASYNCHRONOUS';
  protected $clientFunctionType = ClientFunction::class;
  protected $clientFunctionDataType = '';
  protected $connectorToolType = ConnectorTool::class;
  protected $connectorToolDataType = '';
  /**
   * Output only. Timestamp when the tool was created.
   *
   * @var string
   */
  public $createTime;
  protected $dataStoreToolType = DataStoreTool::class;
  protected $dataStoreToolDataType = '';
  /**
   * Output only. The display name of the tool, derived based on the tool's
   * type. For example, display name of a ClientFunction is derived from its
   * `name` property.
   *
   * @var string
   */
  public $displayName;
  /**
   * Etag used to ensure the object hasn't changed during a read-modify-write
   * operation. If the etag is empty, the update will overwrite any concurrent
   * changes.
   *
   * @var string
   */
  public $etag;
  /**
   * Optional. The execution type of the tool.
   *
   * @var string
   */
  public $executionType;
  protected $fileSearchToolType = FileSearchTool::class;
  protected $fileSearchToolDataType = '';
  /**
   * Output only. If the tool is generated by the LLM assistant, this field
   * contains a descriptive summary of the generation.
   *
   * @var string
   */
  public $generatedSummary;
  protected $googleSearchToolType = GoogleSearchTool::class;
  protected $googleSearchToolDataType = '';
  protected $mcpToolType = McpTool::class;
  protected $mcpToolDataType = '';
  /**
   * Identifier. The unique identifier of the tool. Format: -
   * `projects/{project}/locations/{location}/apps/{app}/tools/{tool}` for ##
   * standalone tools. `projects/{project}/locations/{location}/apps/{app}/tools
   * ets/{toolset}/tools/{tool}` for tools retrieved from a toolset. These tools
   * are dynamic and output-only, they cannot be referenced directly where a
   * tool is expected.
   *
   * @var string
   */
  public $name;
  protected $openApiToolType = OpenApiTool::class;
  protected $openApiToolDataType = '';
  protected $pythonFunctionType = PythonFunction::class;
  protected $pythonFunctionDataType = '';
  protected $systemToolType = SystemTool::class;
  protected $systemToolDataType = '';
  protected $toolFakeConfigType = ToolFakeConfig::class;
  protected $toolFakeConfigDataType = '';
  /**
   * Output only. Timestamp when the tool was last updated.
   *
   * @var string
   */
  public $updateTime;
  protected $widgetToolType = WidgetTool::class;
  protected $widgetToolDataType = '';

  /**
   * Optional. The client function.
   *
   * @param ClientFunction $clientFunction
   */
  public function setClientFunction(ClientFunction $clientFunction)
  {
    $this->clientFunction = $clientFunction;
  }
  /**
   * @return ClientFunction
   */
  public function getClientFunction()
  {
    return $this->clientFunction;
  }
  /**
   * Optional. The Integration Connector tool.
   *
   * @param ConnectorTool $connectorTool
   */
  public function setConnectorTool(ConnectorTool $connectorTool)
  {
    $this->connectorTool = $connectorTool;
  }
  /**
   * @return ConnectorTool
   */
  public function getConnectorTool()
  {
    return $this->connectorTool;
  }
  /**
   * Output only. Timestamp when the tool was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. The data store tool.
   *
   * @param DataStoreTool $dataStoreTool
   */
  public function setDataStoreTool(DataStoreTool $dataStoreTool)
  {
    $this->dataStoreTool = $dataStoreTool;
  }
  /**
   * @return DataStoreTool
   */
  public function getDataStoreTool()
  {
    return $this->dataStoreTool;
  }
  /**
   * Output only. The display name of the tool, derived based on the tool's
   * type. For example, display name of a ClientFunction is derived from its
   * `name` property.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Etag used to ensure the object hasn't changed during a read-modify-write
   * operation. If the etag is empty, the update will overwrite any concurrent
   * changes.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Optional. The execution type of the tool.
   *
   * Accepted values: EXECUTION_TYPE_UNSPECIFIED, SYNCHRONOUS, ASYNCHRONOUS
   *
   * @param self::EXECUTION_TYPE_* $executionType
   */
  public function setExecutionType($executionType)
  {
    $this->executionType = $executionType;
  }
  /**
   * @return self::EXECUTION_TYPE_*
   */
  public function getExecutionType()
  {
    return $this->executionType;
  }
  /**
   * Optional. The file search tool.
   *
   * @param FileSearchTool $fileSearchTool
   */
  public function setFileSearchTool(FileSearchTool $fileSearchTool)
  {
    $this->fileSearchTool = $fileSearchTool;
  }
  /**
   * @return FileSearchTool
   */
  public function getFileSearchTool()
  {
    return $this->fileSearchTool;
  }
  /**
   * Output only. If the tool is generated by the LLM assistant, this field
   * contains a descriptive summary of the generation.
   *
   * @param string $generatedSummary
   */
  public function setGeneratedSummary($generatedSummary)
  {
    $this->generatedSummary = $generatedSummary;
  }
  /**
   * @return string
   */
  public function getGeneratedSummary()
  {
    return $this->generatedSummary;
  }
  /**
   * Optional. The google search tool.
   *
   * @param GoogleSearchTool $googleSearchTool
   */
  public function setGoogleSearchTool(GoogleSearchTool $googleSearchTool)
  {
    $this->googleSearchTool = $googleSearchTool;
  }
  /**
   * @return GoogleSearchTool
   */
  public function getGoogleSearchTool()
  {
    return $this->googleSearchTool;
  }
  /**
   * Optional. The MCP tool. An MCP tool cannot be created or updated directly
   * and is managed by the MCP toolset.
   *
   * @param McpTool $mcpTool
   */
  public function setMcpTool(McpTool $mcpTool)
  {
    $this->mcpTool = $mcpTool;
  }
  /**
   * @return McpTool
   */
  public function getMcpTool()
  {
    return $this->mcpTool;
  }
  /**
   * Identifier. The unique identifier of the tool. Format: -
   * `projects/{project}/locations/{location}/apps/{app}/tools/{tool}` for ##
   * standalone tools. `projects/{project}/locations/{location}/apps/{app}/tools
   * ets/{toolset}/tools/{tool}` for tools retrieved from a toolset. These tools
   * are dynamic and output-only, they cannot be referenced directly where a
   * tool is expected.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. The open API tool.
   *
   * @param OpenApiTool $openApiTool
   */
  public function setOpenApiTool(OpenApiTool $openApiTool)
  {
    $this->openApiTool = $openApiTool;
  }
  /**
   * @return OpenApiTool
   */
  public function getOpenApiTool()
  {
    return $this->openApiTool;
  }
  /**
   * Optional. The python function tool.
   *
   * @param PythonFunction $pythonFunction
   */
  public function setPythonFunction(PythonFunction $pythonFunction)
  {
    $this->pythonFunction = $pythonFunction;
  }
  /**
   * @return PythonFunction
   */
  public function getPythonFunction()
  {
    return $this->pythonFunction;
  }
  /**
   * Optional. The system tool.
   *
   * @param SystemTool $systemTool
   */
  public function setSystemTool(SystemTool $systemTool)
  {
    $this->systemTool = $systemTool;
  }
  /**
   * @return SystemTool
   */
  public function getSystemTool()
  {
    return $this->systemTool;
  }
  /**
   * Optional. Configuration for tool behavior in fake mode.
   *
   * @param ToolFakeConfig $toolFakeConfig
   */
  public function setToolFakeConfig(ToolFakeConfig $toolFakeConfig)
  {
    $this->toolFakeConfig = $toolFakeConfig;
  }
  /**
   * @return ToolFakeConfig
   */
  public function getToolFakeConfig()
  {
    return $this->toolFakeConfig;
  }
  /**
   * Output only. Timestamp when the tool was last updated.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Optional. The widget tool.
   *
   * @param WidgetTool $widgetTool
   */
  public function setWidgetTool(WidgetTool $widgetTool)
  {
    $this->widgetTool = $widgetTool;
  }
  /**
   * @return WidgetTool
   */
  public function getWidgetTool()
  {
    return $this->widgetTool;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Tool::class, 'Google_Service_CustomerEngagementSuite_Tool');
