<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class GoogleCloudSecuritycenterV2AdcApplication extends \Google\Model
{
  protected $attributesType = GoogleCloudSecuritycenterV2ResourceApplicationAttributes::class;
  protected $attributesDataType = '';
  /**
   * The resource name of an ADC Application. Format: projects/{project}/locatio
   * ns/{location}/spaces/{space}/applications/{application}
   *
   * @var string
   */
  public $name;

  /**
   * Consumer provided attributes for the AppHub application.
   *
   * @param GoogleCloudSecuritycenterV2ResourceApplicationAttributes $attributes
   */
  public function setAttributes(GoogleCloudSecuritycenterV2ResourceApplicationAttributes $attributes)
  {
    $this->attributes = $attributes;
  }
  /**
   * @return GoogleCloudSecuritycenterV2ResourceApplicationAttributes
   */
  public function getAttributes()
  {
    return $this->attributes;
  }
  /**
   * The resource name of an ADC Application. Format: projects/{project}/locatio
   * ns/{location}/spaces/{space}/applications/{application}
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudSecuritycenterV2AdcApplication::class, 'Google_Service_SecurityCommandCenter_GoogleCloudSecuritycenterV2AdcApplication');
