<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class GoogleCloudSecuritycenterV2Denied extends \Google\Collection
{
  protected $collection_key = 'ipRules';
  protected $ipRulesType = GoogleCloudSecuritycenterV2IpRule::class;
  protected $ipRulesDataType = 'array';

  /**
   * Optional. Optional list of denied IP rules.
   *
   * @param GoogleCloudSecuritycenterV2IpRule[] $ipRules
   */
  public function setIpRules($ipRules)
  {
    $this->ipRules = $ipRules;
  }
  /**
   * @return GoogleCloudSecuritycenterV2IpRule[]
   */
  public function getIpRules()
  {
    return $this->ipRules;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudSecuritycenterV2Denied::class, 'Google_Service_SecurityCommandCenter_GoogleCloudSecuritycenterV2Denied');
